/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.domdebugger;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v90.dom.model.NodeId;
import org.openqa.selenium.devtools.v90.domdebugger.model.CSPViolationType;
import org.openqa.selenium.devtools.v90.domdebugger.model.DOMBreakpointType;
import org.openqa.selenium.devtools.v90.domdebugger.model.EventListener;
import org.openqa.selenium.devtools.v90.runtime.model.RemoteObjectId;

public class DOMDebugger {
    public static Command<List<EventListener>> getEventListeners(RemoteObjectId objectId, Optional<Integer> depth, Optional<Boolean> pierce) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command("DOMDebugger.getEventListeners", (Map)params.build(), ConverterFunctions.map((String)"listeners", (Type)new TypeToken<List<EventListener>>(){}.getType()));
    }

    public static Command<Void> removeDOMBreakpoint(NodeId nodeId, DOMBreakpointType type) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"type", (Object)type);
        return new Command("DOMDebugger.removeDOMBreakpoint", (Map)params.build());
    }

    public static Command<Void> removeEventListenerBreakpoint(String eventName, Optional<String> targetName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventName", (Object)eventName);
        targetName.ifPresent(p -> params.put((Object)"targetName", p));
        return new Command("DOMDebugger.removeEventListenerBreakpoint", (Map)params.build());
    }

    @Beta
    public static Command<Void> removeInstrumentationBreakpoint(String eventName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventName", (Object)eventName);
        return new Command("DOMDebugger.removeInstrumentationBreakpoint", (Map)params.build());
    }

    public static Command<Void> removeXHRBreakpoint(String url) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"url", (Object)url);
        return new Command("DOMDebugger.removeXHRBreakpoint", (Map)params.build());
    }

    @Beta
    public static Command<Void> setBreakOnCSPViolation(List<CSPViolationType> violationTypes) {
        Objects.requireNonNull(violationTypes, "violationTypes is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"violationTypes", violationTypes);
        return new Command("DOMDebugger.setBreakOnCSPViolation", (Map)params.build());
    }

    public static Command<Void> setDOMBreakpoint(NodeId nodeId, DOMBreakpointType type) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"type", (Object)type);
        return new Command("DOMDebugger.setDOMBreakpoint", (Map)params.build());
    }

    public static Command<Void> setEventListenerBreakpoint(String eventName, Optional<String> targetName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventName", (Object)eventName);
        targetName.ifPresent(p -> params.put((Object)"targetName", p));
        return new Command("DOMDebugger.setEventListenerBreakpoint", (Map)params.build());
    }

    @Beta
    public static Command<Void> setInstrumentationBreakpoint(String eventName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventName", (Object)eventName);
        return new Command("DOMDebugger.setInstrumentationBreakpoint", (Map)params.build());
    }

    public static Command<Void> setXHRBreakpoint(String url) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"url", (Object)url);
        return new Command("DOMDebugger.setXHRBreakpoint", (Map)params.build());
    }
}

