/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.applicationcache;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v90.applicationcache.model.ApplicationCacheStatusUpdated;
import org.openqa.selenium.devtools.v90.applicationcache.model.FrameWithManifest;
import org.openqa.selenium.devtools.v90.page.model.FrameId;

@Beta
public class ApplicationCache {
    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("ApplicationCache.enable", (Map)params.build());
    }

    public static Command<org.openqa.selenium.devtools.v90.applicationcache.model.ApplicationCache> getApplicationCacheForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command("ApplicationCache.getApplicationCacheForFrame", (Map)params.build(), ConverterFunctions.map((String)"applicationCache", org.openqa.selenium.devtools.v90.applicationcache.model.ApplicationCache.class));
    }

    public static Command<List<FrameWithManifest>> getFramesWithManifests() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("ApplicationCache.getFramesWithManifests", (Map)params.build(), ConverterFunctions.map((String)"frameIds", (Type)new TypeToken<List<FrameWithManifest>>(){}.getType()));
    }

    public static Command<String> getManifestForFrame(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command("ApplicationCache.getManifestForFrame", (Map)params.build(), ConverterFunctions.map((String)"manifestURL", String.class));
    }

    public static Event<ApplicationCacheStatusUpdated> applicationCacheStatusUpdated() {
        return new Event("ApplicationCache.applicationCacheStatusUpdated", input -> (ApplicationCacheStatusUpdated)input.read(ApplicationCacheStatusUpdated.class));
    }

    public static Event<Boolean> networkStateUpdated() {
        return new Event("ApplicationCache.networkStateUpdated", ConverterFunctions.map((String)"isNowOnline", Boolean.class));
    }
}

