package org.openqa.selenium.devtools.v85.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration data for the highlighting of Grid elements.
 */
public class GridHighlightConfig {

    private final java.util.Optional<java.lang.Boolean> showGridExtensionLines;

    private final java.util.Optional<java.lang.Boolean> showPositiveLineNumbers;

    private final java.util.Optional<java.lang.Boolean> showNegativeLineNumbers;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> gridBorderColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> cellBorderColor;

    private final java.util.Optional<java.lang.Boolean> gridBorderDash;

    private final java.util.Optional<java.lang.Boolean> cellBorderDash;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> rowGapColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> rowHatchColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> columnGapColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> columnHatchColor;

    public GridHighlightConfig(java.util.Optional<java.lang.Boolean> showGridExtensionLines, java.util.Optional<java.lang.Boolean> showPositiveLineNumbers, java.util.Optional<java.lang.Boolean> showNegativeLineNumbers, java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> gridBorderColor, java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> cellBorderColor, java.util.Optional<java.lang.Boolean> gridBorderDash, java.util.Optional<java.lang.Boolean> cellBorderDash, java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> rowGapColor, java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> rowHatchColor, java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> columnGapColor, java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> columnHatchColor) {
        this.showGridExtensionLines = showGridExtensionLines;
        this.showPositiveLineNumbers = showPositiveLineNumbers;
        this.showNegativeLineNumbers = showNegativeLineNumbers;
        this.gridBorderColor = gridBorderColor;
        this.cellBorderColor = cellBorderColor;
        this.gridBorderDash = gridBorderDash;
        this.cellBorderDash = cellBorderDash;
        this.rowGapColor = rowGapColor;
        this.rowHatchColor = rowHatchColor;
        this.columnGapColor = columnGapColor;
        this.columnHatchColor = columnHatchColor;
    }

    /**
     * Whether the extension lines from grid cells to the rulers should be shown (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowGridExtensionLines() {
        return showGridExtensionLines;
    }

    /**
     * Show Positive line number labels (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowPositiveLineNumbers() {
        return showPositiveLineNumbers;
    }

    /**
     * Show Negative line number labels (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowNegativeLineNumbers() {
        return showNegativeLineNumbers;
    }

    /**
     * The grid container border highlight color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> getGridBorderColor() {
        return gridBorderColor;
    }

    /**
     * The cell border color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> getCellBorderColor() {
        return cellBorderColor;
    }

    /**
     * Whether the grid border is dashed (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getGridBorderDash() {
        return gridBorderDash;
    }

    /**
     * Whether the cell border is dashed (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getCellBorderDash() {
        return cellBorderDash;
    }

    /**
     * The row gap highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> getRowGapColor() {
        return rowGapColor;
    }

    /**
     * The row gap hatching fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> getRowHatchColor() {
        return rowHatchColor;
    }

    /**
     * The column gap highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> getColumnGapColor() {
        return columnGapColor;
    }

    /**
     * The column gap hatching fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> getColumnHatchColor() {
        return columnHatchColor;
    }

    private static GridHighlightConfig fromJson(JsonInput input) {
        java.util.Optional<java.lang.Boolean> showGridExtensionLines = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showPositiveLineNumbers = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showNegativeLineNumbers = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> gridBorderColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> cellBorderColor = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> gridBorderDash = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> cellBorderDash = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> rowGapColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> rowHatchColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> columnGapColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.RGBA> columnHatchColor = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "showGridExtensionLines":
                    showGridExtensionLines = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showPositiveLineNumbers":
                    showPositiveLineNumbers = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showNegativeLineNumbers":
                    showNegativeLineNumbers = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "gridBorderColor":
                    gridBorderColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.dom.model.RGBA.class));
                    break;
                case "cellBorderColor":
                    cellBorderColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.dom.model.RGBA.class));
                    break;
                case "gridBorderDash":
                    gridBorderDash = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "cellBorderDash":
                    cellBorderDash = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "rowGapColor":
                    rowGapColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.dom.model.RGBA.class));
                    break;
                case "rowHatchColor":
                    rowHatchColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.dom.model.RGBA.class));
                    break;
                case "columnGapColor":
                    columnGapColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.dom.model.RGBA.class));
                    break;
                case "columnHatchColor":
                    columnHatchColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.dom.model.RGBA.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new GridHighlightConfig(showGridExtensionLines, showPositiveLineNumbers, showNegativeLineNumbers, gridBorderColor, cellBorderColor, gridBorderDash, cellBorderDash, rowGapColor, rowHatchColor, columnGapColor, columnHatchColor);
    }
}
