/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.network;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.debugger.model.SearchMatch;
import org.openqa.selenium.devtools.v85.emulation.model.UserAgentMetadata;
import org.openqa.selenium.devtools.v85.io.model.StreamHandle;
import org.openqa.selenium.devtools.v85.network.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v85.network.model.ConnectionType;
import org.openqa.selenium.devtools.v85.network.model.Cookie;
import org.openqa.selenium.devtools.v85.network.model.CookieParam;
import org.openqa.selenium.devtools.v85.network.model.CookiePriority;
import org.openqa.selenium.devtools.v85.network.model.CookieSameSite;
import org.openqa.selenium.devtools.v85.network.model.DataReceived;
import org.openqa.selenium.devtools.v85.network.model.ErrorReason;
import org.openqa.selenium.devtools.v85.network.model.EventSourceMessageReceived;
import org.openqa.selenium.devtools.v85.network.model.Headers;
import org.openqa.selenium.devtools.v85.network.model.InterceptionId;
import org.openqa.selenium.devtools.v85.network.model.LoadingFailed;
import org.openqa.selenium.devtools.v85.network.model.LoadingFinished;
import org.openqa.selenium.devtools.v85.network.model.RequestId;
import org.openqa.selenium.devtools.v85.network.model.RequestIntercepted;
import org.openqa.selenium.devtools.v85.network.model.RequestPattern;
import org.openqa.selenium.devtools.v85.network.model.RequestWillBeSent;
import org.openqa.selenium.devtools.v85.network.model.RequestWillBeSentExtraInfo;
import org.openqa.selenium.devtools.v85.network.model.ResourceChangedPriority;
import org.openqa.selenium.devtools.v85.network.model.ResponseReceived;
import org.openqa.selenium.devtools.v85.network.model.ResponseReceivedExtraInfo;
import org.openqa.selenium.devtools.v85.network.model.SignedExchangeReceived;
import org.openqa.selenium.devtools.v85.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v85.network.model.WebSocketClosed;
import org.openqa.selenium.devtools.v85.network.model.WebSocketCreated;
import org.openqa.selenium.devtools.v85.network.model.WebSocketFrameError;
import org.openqa.selenium.devtools.v85.network.model.WebSocketFrameReceived;
import org.openqa.selenium.devtools.v85.network.model.WebSocketFrameSent;
import org.openqa.selenium.devtools.v85.network.model.WebSocketHandshakeResponseReceived;
import org.openqa.selenium.devtools.v85.network.model.WebSocketWillSendHandshakeRequest;
import org.openqa.selenium.json.JsonInput;

public class Network {
    @Deprecated
    public static Command<Boolean> canClearBrowserCache() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Network.canClearBrowserCache", Map.copyOf(params), ConverterFunctions.map((String)"result", Boolean.class));
    }

    @Deprecated
    public static Command<Boolean> canClearBrowserCookies() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Network.canClearBrowserCookies", Map.copyOf(params), ConverterFunctions.map((String)"result", Boolean.class));
    }

    @Deprecated
    public static Command<Boolean> canEmulateNetworkConditions() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Network.canEmulateNetworkConditions", Map.copyOf(params), ConverterFunctions.map((String)"result", Boolean.class));
    }

    public static Command<Void> clearBrowserCache() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Network.clearBrowserCache", Map.copyOf(params));
    }

    public static Command<Void> clearBrowserCookies() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Network.clearBrowserCookies", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> continueInterceptedRequest(InterceptionId interceptionId, Optional<ErrorReason> errorReason, Optional<String> rawResponse, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<Headers> headers, Optional<AuthChallengeResponse> authChallengeResponse) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        LinkedHashMap<String, InterceptionId> params = new LinkedHashMap<String, InterceptionId>();
        params.put("interceptionId", interceptionId);
        errorReason.ifPresent(p -> params.put("errorReason", (InterceptionId)p));
        rawResponse.ifPresent(p -> params.put("rawResponse", (InterceptionId)p));
        url.ifPresent(p -> params.put("url", (InterceptionId)p));
        method.ifPresent(p -> params.put("method", (InterceptionId)p));
        postData.ifPresent(p -> params.put("postData", (InterceptionId)p));
        headers.ifPresent(p -> params.put("headers", (InterceptionId)p));
        authChallengeResponse.ifPresent(p -> params.put("authChallengeResponse", (InterceptionId)p));
        return new Command("Network.continueInterceptedRequest", Map.copyOf(params));
    }

    public static Command<Void> deleteCookies(String name, Optional<String> url, Optional<String> domain, Optional<String> path) {
        Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("name", name);
        url.ifPresent(p -> params.put("url", (String)p));
        domain.ifPresent(p -> params.put("domain", (String)p));
        path.ifPresent(p -> params.put("path", (String)p));
        return new Command("Network.deleteCookies", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Network.disable", Map.copyOf(params));
    }

    public static Command<Void> emulateNetworkConditions(Boolean offline, Number latency, Number downloadThroughput, Number uploadThroughput, Optional<ConnectionType> connectionType) {
        Objects.requireNonNull(offline, "offline is required");
        Objects.requireNonNull(latency, "latency is required");
        Objects.requireNonNull(downloadThroughput, "downloadThroughput is required");
        Objects.requireNonNull(uploadThroughput, "uploadThroughput is required");
        LinkedHashMap<String, Serializable> params = new LinkedHashMap<String, Serializable>();
        params.put("offline", offline);
        params.put("latency", latency);
        params.put("downloadThroughput", downloadThroughput);
        params.put("uploadThroughput", uploadThroughput);
        connectionType.ifPresent(p -> params.put("connectionType", (Serializable)p));
        return new Command("Network.emulateNetworkConditions", Map.copyOf(params));
    }

    public static Command<Void> enable(Optional<Integer> maxTotalBufferSize, Optional<Integer> maxResourceBufferSize, Optional<Integer> maxPostDataSize) {
        LinkedHashMap params = new LinkedHashMap();
        maxTotalBufferSize.ifPresent(p -> params.put("maxTotalBufferSize", p));
        maxResourceBufferSize.ifPresent(p -> params.put("maxResourceBufferSize", p));
        maxPostDataSize.ifPresent(p -> params.put("maxPostDataSize", p));
        return new Command("Network.enable", Map.copyOf(params));
    }

    public static Command<List<Cookie>> getAllCookies() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Network.getAllCookies", Map.copyOf(params), ConverterFunctions.map((String)"cookies", List.class));
    }

    @Beta
    public static Command<List<String>> getCertificate(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("origin", origin);
        return new Command("Network.getCertificate", Map.copyOf(params), ConverterFunctions.map((String)"tableNames", List.class));
    }

    public static Command<List<Cookie>> getCookies(Optional<List<String>> urls) {
        LinkedHashMap params = new LinkedHashMap();
        urls.ifPresent(p -> params.put("urls", p));
        return new Command("Network.getCookies", Map.copyOf(params), ConverterFunctions.map((String)"cookies", List.class));
    }

    public static Command<GetResponseBodyResponse> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        return new Command("Network.getResponseBody", Map.copyOf(params), input -> (GetResponseBodyResponse)input.read(GetResponseBodyResponse.class));
    }

    public static Command<String> getRequestPostData(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        return new Command("Network.getRequestPostData", Map.copyOf(params), ConverterFunctions.map((String)"postData", String.class));
    }

    @Beta
    public static Command<GetResponseBodyForInterceptionResponse> getResponseBodyForInterception(InterceptionId interceptionId) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        LinkedHashMap<String, InterceptionId> params = new LinkedHashMap<String, InterceptionId>();
        params.put("interceptionId", interceptionId);
        return new Command("Network.getResponseBodyForInterception", Map.copyOf(params), input -> (GetResponseBodyForInterceptionResponse)input.read(GetResponseBodyForInterceptionResponse.class));
    }

    @Beta
    public static Command<StreamHandle> takeResponseBodyForInterceptionAsStream(InterceptionId interceptionId) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        LinkedHashMap<String, InterceptionId> params = new LinkedHashMap<String, InterceptionId>();
        params.put("interceptionId", interceptionId);
        return new Command("Network.takeResponseBodyForInterceptionAsStream", Map.copyOf(params), ConverterFunctions.map((String)"stream", StreamHandle.class));
    }

    @Beta
    public static Command<Void> replayXHR(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        LinkedHashMap<String, RequestId> params = new LinkedHashMap<String, RequestId>();
        params.put("requestId", requestId);
        return new Command("Network.replayXHR", Map.copyOf(params));
    }

    @Beta
    public static Command<List<SearchMatch>> searchInResponseBody(RequestId requestId, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(query, "query is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("requestId", requestId);
        params.put("query", query);
        caseSensitive.ifPresent(p -> params.put("caseSensitive", p));
        isRegex.ifPresent(p -> params.put("isRegex", p));
        return new Command("Network.searchInResponseBody", Map.copyOf(params), ConverterFunctions.map((String)"result", List.class));
    }

    @Beta
    public static Command<Void> setBlockedURLs(List<String> urls) {
        Objects.requireNonNull(urls, "urls is required");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("urls", urls);
        return new Command("Network.setBlockedURLs", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setBypassServiceWorker(Boolean bypass) {
        Objects.requireNonNull(bypass, "bypass is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("bypass", bypass);
        return new Command("Network.setBypassServiceWorker", Map.copyOf(params));
    }

    public static Command<Void> setCacheDisabled(Boolean cacheDisabled) {
        Objects.requireNonNull(cacheDisabled, "cacheDisabled is required");
        LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
        params.put("cacheDisabled", cacheDisabled);
        return new Command("Network.setCacheDisabled", Map.copyOf(params));
    }

    public static Command<Boolean> setCookie(String name, String value, Optional<String> url, Optional<String> domain, Optional<String> path, Optional<Boolean> secure, Optional<Boolean> httpOnly, Optional<CookieSameSite> sameSite, Optional<TimeSinceEpoch> expires, Optional<CookiePriority> priority) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("name", name);
        params.put("value", value);
        url.ifPresent(p -> params.put("url", (String)p));
        domain.ifPresent(p -> params.put("domain", (String)p));
        path.ifPresent(p -> params.put("path", (String)p));
        secure.ifPresent(p -> params.put("secure", (String)p));
        httpOnly.ifPresent(p -> params.put("httpOnly", (String)p));
        sameSite.ifPresent(p -> params.put("sameSite", (String)p));
        expires.ifPresent(p -> params.put("expires", (String)p));
        priority.ifPresent(p -> params.put("priority", (String)p));
        return new Command("Network.setCookie", Map.copyOf(params), ConverterFunctions.map((String)"success", Boolean.class));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies) {
        Objects.requireNonNull(cookies, "cookies is required");
        LinkedHashMap<String, List<CookieParam>> params = new LinkedHashMap<String, List<CookieParam>>();
        params.put("cookies", cookies);
        return new Command("Network.setCookies", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setDataSizeLimitsForTest(Integer maxTotalSize, Integer maxResourceSize) {
        Objects.requireNonNull(maxTotalSize, "maxTotalSize is required");
        Objects.requireNonNull(maxResourceSize, "maxResourceSize is required");
        LinkedHashMap<String, Integer> params = new LinkedHashMap<String, Integer>();
        params.put("maxTotalSize", maxTotalSize);
        params.put("maxResourceSize", maxResourceSize);
        return new Command("Network.setDataSizeLimitsForTest", Map.copyOf(params));
    }

    public static Command<Void> setExtraHTTPHeaders(Headers headers) {
        Objects.requireNonNull(headers, "headers is required");
        LinkedHashMap<String, Headers> params = new LinkedHashMap<String, Headers>();
        params.put("headers", headers);
        return new Command("Network.setExtraHTTPHeaders", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setRequestInterception(List<RequestPattern> patterns) {
        Objects.requireNonNull(patterns, "patterns is required");
        LinkedHashMap<String, List<RequestPattern>> params = new LinkedHashMap<String, List<RequestPattern>>();
        params.put("patterns", patterns);
        return new Command("Network.setRequestInterception", Map.copyOf(params));
    }

    public static Command<Void> setUserAgentOverride(String userAgent, Optional<String> acceptLanguage, Optional<String> platform, Optional<UserAgentMetadata> userAgentMetadata) {
        Objects.requireNonNull(userAgent, "userAgent is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("userAgent", userAgent);
        acceptLanguage.ifPresent(p -> params.put("acceptLanguage", (String)p));
        platform.ifPresent(p -> params.put("platform", (String)p));
        userAgentMetadata.ifPresent(p -> params.put("userAgentMetadata", (String)p));
        return new Command("Network.setUserAgentOverride", Map.copyOf(params));
    }

    public static Event<DataReceived> dataReceived() {
        return new Event("Network.dataReceived", input -> (DataReceived)input.read(DataReceived.class));
    }

    public static Event<EventSourceMessageReceived> eventSourceMessageReceived() {
        return new Event("Network.eventSourceMessageReceived", input -> (EventSourceMessageReceived)input.read(EventSourceMessageReceived.class));
    }

    public static Event<LoadingFailed> loadingFailed() {
        return new Event("Network.loadingFailed", input -> (LoadingFailed)input.read(LoadingFailed.class));
    }

    public static Event<LoadingFinished> loadingFinished() {
        return new Event("Network.loadingFinished", input -> (LoadingFinished)input.read(LoadingFinished.class));
    }

    public static Event<RequestIntercepted> requestIntercepted() {
        return new Event("Network.requestIntercepted", input -> (RequestIntercepted)input.read(RequestIntercepted.class));
    }

    public static Event<RequestId> requestServedFromCache() {
        return new Event("Network.requestServedFromCache", ConverterFunctions.map((String)"requestId", RequestId.class));
    }

    public static Event<RequestWillBeSent> requestWillBeSent() {
        return new Event("Network.requestWillBeSent", input -> (RequestWillBeSent)input.read(RequestWillBeSent.class));
    }

    public static Event<ResourceChangedPriority> resourceChangedPriority() {
        return new Event("Network.resourceChangedPriority", input -> (ResourceChangedPriority)input.read(ResourceChangedPriority.class));
    }

    public static Event<SignedExchangeReceived> signedExchangeReceived() {
        return new Event("Network.signedExchangeReceived", input -> (SignedExchangeReceived)input.read(SignedExchangeReceived.class));
    }

    public static Event<ResponseReceived> responseReceived() {
        return new Event("Network.responseReceived", input -> (ResponseReceived)input.read(ResponseReceived.class));
    }

    public static Event<WebSocketClosed> webSocketClosed() {
        return new Event("Network.webSocketClosed", input -> (WebSocketClosed)input.read(WebSocketClosed.class));
    }

    public static Event<WebSocketCreated> webSocketCreated() {
        return new Event("Network.webSocketCreated", input -> (WebSocketCreated)input.read(WebSocketCreated.class));
    }

    public static Event<WebSocketFrameError> webSocketFrameError() {
        return new Event("Network.webSocketFrameError", input -> (WebSocketFrameError)input.read(WebSocketFrameError.class));
    }

    public static Event<WebSocketFrameReceived> webSocketFrameReceived() {
        return new Event("Network.webSocketFrameReceived", input -> (WebSocketFrameReceived)input.read(WebSocketFrameReceived.class));
    }

    public static Event<WebSocketFrameSent> webSocketFrameSent() {
        return new Event("Network.webSocketFrameSent", input -> (WebSocketFrameSent)input.read(WebSocketFrameSent.class));
    }

    public static Event<WebSocketHandshakeResponseReceived> webSocketHandshakeResponseReceived() {
        return new Event("Network.webSocketHandshakeResponseReceived", input -> (WebSocketHandshakeResponseReceived)input.read(WebSocketHandshakeResponseReceived.class));
    }

    public static Event<WebSocketWillSendHandshakeRequest> webSocketWillSendHandshakeRequest() {
        return new Event("Network.webSocketWillSendHandshakeRequest", input -> (WebSocketWillSendHandshakeRequest)input.read(WebSocketWillSendHandshakeRequest.class));
    }

    public static Event<RequestWillBeSentExtraInfo> requestWillBeSentExtraInfo() {
        return new Event("Network.requestWillBeSentExtraInfo", input -> (RequestWillBeSentExtraInfo)input.read(RequestWillBeSentExtraInfo.class));
    }

    public static Event<ResponseReceivedExtraInfo> responseReceivedExtraInfo() {
        return new Event("Network.responseReceivedExtraInfo", input -> (ResponseReceivedExtraInfo)input.read(ResponseReceivedExtraInfo.class));
    }

    public static class GetResponseBodyForInterceptionResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyForInterceptionResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyForInterceptionResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyForInterceptionResponse(body, base64Encoded);
        }
    }

    public static class GetResponseBodyResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyResponse(body, base64Encoded);
        }
    }
}

