/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.runtime.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v134.runtime.model.ExecutionContextId;
import org.openqa.selenium.json.JsonInput;

public class ExecutionContextDescription {
    private final ExecutionContextId id;
    private final String origin;
    private final String name;
    private final String uniqueId;
    private final Optional<Map<String, Object>> auxData;

    public ExecutionContextDescription(ExecutionContextId id, String origin, String name, String uniqueId, Optional<Map<String, Object>> auxData) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.uniqueId = Objects.requireNonNull(uniqueId, "uniqueId is required");
        this.auxData = auxData;
    }

    public ExecutionContextId getId() {
        return this.id;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getName() {
        return this.name;
    }

    @Beta
    public String getUniqueId() {
        return this.uniqueId;
    }

    public Optional<Map<String, Object>> getAuxData() {
        return this.auxData;
    }

    private static ExecutionContextDescription fromJson(JsonInput input) {
        ExecutionContextId id = null;
        String origin = null;
        String name = null;
        String uniqueId = null;
        Optional<Map<String, Object>> auxData = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (ExecutionContextId)input.read(ExecutionContextId.class);
                    continue block14;
                }
                case "origin": {
                    origin = input.nextString();
                    continue block14;
                }
                case "name": {
                    name = input.nextString();
                    continue block14;
                }
                case "uniqueId": {
                    uniqueId = input.nextString();
                    continue block14;
                }
                case "auxData": {
                    auxData = Optional.ofNullable((Map)input.read(Map.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ExecutionContextDescription(id, origin, name, uniqueId, auxData);
    }
}

