package org.openqa.selenium.devtools.v131.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * One of the interest groups was accessed. Note that these events are global
 * to all targets sharing an interest group store.
 */
public class InterestGroupAccessed {

    private final org.openqa.selenium.devtools.v131.network.model.TimeSinceEpoch accessTime;

    private final org.openqa.selenium.devtools.v131.storage.model.InterestGroupAccessType type;

    private final java.lang.String ownerOrigin;

    private final java.lang.String name;

    private final java.util.Optional<java.lang.String> componentSellerOrigin;

    private final java.util.Optional<java.lang.Number> bid;

    private final java.util.Optional<java.lang.String> bidCurrency;

    private final java.util.Optional<org.openqa.selenium.devtools.v131.storage.model.InterestGroupAuctionId> uniqueAuctionId;

    public InterestGroupAccessed(org.openqa.selenium.devtools.v131.network.model.TimeSinceEpoch accessTime, org.openqa.selenium.devtools.v131.storage.model.InterestGroupAccessType type, java.lang.String ownerOrigin, java.lang.String name, java.util.Optional<java.lang.String> componentSellerOrigin, java.util.Optional<java.lang.Number> bid, java.util.Optional<java.lang.String> bidCurrency, java.util.Optional<org.openqa.selenium.devtools.v131.storage.model.InterestGroupAuctionId> uniqueAuctionId) {
        this.accessTime = java.util.Objects.requireNonNull(accessTime, "accessTime is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.ownerOrigin = java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.componentSellerOrigin = componentSellerOrigin;
        this.bid = bid;
        this.bidCurrency = bidCurrency;
        this.uniqueAuctionId = uniqueAuctionId;
    }

    public org.openqa.selenium.devtools.v131.network.model.TimeSinceEpoch getAccessTime() {
        return accessTime;
    }

    public org.openqa.selenium.devtools.v131.storage.model.InterestGroupAccessType getType() {
        return type;
    }

    public java.lang.String getOwnerOrigin() {
        return ownerOrigin;
    }

    public java.lang.String getName() {
        return name;
    }

    /**
     * For topLevelBid/topLevelAdditionalBid, and when appropriate,
     * win and additionalBidWin
     */
    public java.util.Optional<java.lang.String> getComponentSellerOrigin() {
        return componentSellerOrigin;
    }

    /**
     * For bid or somethingBid event, if done locally and not on a server.
     */
    public java.util.Optional<java.lang.Number> getBid() {
        return bid;
    }

    public java.util.Optional<java.lang.String> getBidCurrency() {
        return bidCurrency;
    }

    /**
     * For non-global events --- links to interestGroupAuctionEvent
     */
    public java.util.Optional<org.openqa.selenium.devtools.v131.storage.model.InterestGroupAuctionId> getUniqueAuctionId() {
        return uniqueAuctionId;
    }

    private static InterestGroupAccessed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v131.network.model.TimeSinceEpoch accessTime = null;
        org.openqa.selenium.devtools.v131.storage.model.InterestGroupAccessType type = null;
        java.lang.String ownerOrigin = null;
        java.lang.String name = null;
        java.util.Optional<java.lang.String> componentSellerOrigin = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> bid = java.util.Optional.empty();
        java.util.Optional<java.lang.String> bidCurrency = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v131.storage.model.InterestGroupAuctionId> uniqueAuctionId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "accessTime":
                    accessTime = input.read(org.openqa.selenium.devtools.v131.network.model.TimeSinceEpoch.class);
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v131.storage.model.InterestGroupAccessType.class);
                    break;
                case "ownerOrigin":
                    ownerOrigin = input.nextString();
                    break;
                case "name":
                    name = input.nextString();
                    break;
                case "componentSellerOrigin":
                    componentSellerOrigin = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "bid":
                    bid = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "bidCurrency":
                    bidCurrency = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "uniqueAuctionId":
                    uniqueAuctionId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v131.storage.model.InterestGroupAuctionId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InterestGroupAccessed(accessTime, type, ownerOrigin, name, componentSellerOrigin, bid, bidCurrency, uniqueAuctionId);
    }
}
