package org.openqa.selenium.devtools.v129.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * TODO(https://crbug.com/1384419): revisit the list of PrefetchStatus and
 * filter out the ones that aren't necessary to the developers.
 */
public enum PrefetchStatus {

    PREFETCHALLOWED("PrefetchAllowed"),
    PREFETCHFAILEDINELIGIBLEREDIRECT("PrefetchFailedIneligibleRedirect"),
    PREFETCHFAILEDINVALIDREDIRECT("PrefetchFailedInvalidRedirect"),
    PREFETCHFAILEDMIMENOTSUPPORTED("PrefetchFailedMIMENotSupported"),
    PREFETCHFAILEDNETERROR("PrefetchFailedNetError"),
    PREFETCHFAILEDNON2XX("PrefetchFailedNon2XX"),
    PREFETCHFAILEDPERPAGELIMITEXCEEDED("PrefetchFailedPerPageLimitExceeded"),
    PREFETCHEVICTEDAFTERCANDIDATEREMOVED("PrefetchEvictedAfterCandidateRemoved"),
    PREFETCHEVICTEDFORNEWERPREFETCH("PrefetchEvictedForNewerPrefetch"),
    PREFETCHHELDBACK("PrefetchHeldback"),
    PREFETCHINELIGIBLERETRYAFTER("PrefetchIneligibleRetryAfter"),
    PREFETCHISPRIVACYDECOY("PrefetchIsPrivacyDecoy"),
    PREFETCHISSTALE("PrefetchIsStale"),
    PREFETCHNOTELIGIBLEBROWSERCONTEXTOFFTHERECORD("PrefetchNotEligibleBrowserContextOffTheRecord"),
    PREFETCHNOTELIGIBLEDATASAVERENABLED("PrefetchNotEligibleDataSaverEnabled"),
    PREFETCHNOTELIGIBLEEXISTINGPROXY("PrefetchNotEligibleExistingProxy"),
    PREFETCHNOTELIGIBLEHOSTISNONUNIQUE("PrefetchNotEligibleHostIsNonUnique"),
    PREFETCHNOTELIGIBLENONDEFAULTSTORAGEPARTITION("PrefetchNotEligibleNonDefaultStoragePartition"),
    PREFETCHNOTELIGIBLESAMESITECROSSORIGINPREFETCHREQUIREDPROXY("PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy"),
    PREFETCHNOTELIGIBLESCHEMEISNOTHTTPS("PrefetchNotEligibleSchemeIsNotHttps"),
    PREFETCHNOTELIGIBLEUSERHASCOOKIES("PrefetchNotEligibleUserHasCookies"),
    PREFETCHNOTELIGIBLEUSERHASSERVICEWORKER("PrefetchNotEligibleUserHasServiceWorker"),
    PREFETCHNOTELIGIBLEBATTERYSAVERENABLED("PrefetchNotEligibleBatterySaverEnabled"),
    PREFETCHNOTELIGIBLEPRELOADINGDISABLED("PrefetchNotEligiblePreloadingDisabled"),
    PREFETCHNOTFINISHEDINTIME("PrefetchNotFinishedInTime"),
    PREFETCHNOTSTARTED("PrefetchNotStarted"),
    PREFETCHNOTUSEDCOOKIESCHANGED("PrefetchNotUsedCookiesChanged"),
    PREFETCHPROXYNOTAVAILABLE("PrefetchProxyNotAvailable"),
    PREFETCHRESPONSEUSED("PrefetchResponseUsed"),
    PREFETCHSUCCESSFULBUTNOTUSED("PrefetchSuccessfulButNotUsed"),
    PREFETCHNOTUSEDPROBEFAILED("PrefetchNotUsedProbeFailed");

    private String value;

    PrefetchStatus(String value) {
        this.value = value;
    }

    public static PrefetchStatus fromString(String s) {
        return java.util.Arrays.stream(PrefetchStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PrefetchStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PrefetchStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
