package org.openqa.selenium.devtools.v129.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ClientSecurityState {

    private final java.lang.Boolean initiatorIsSecureContext;

    private final org.openqa.selenium.devtools.v129.network.model.IPAddressSpace initiatorIPAddressSpace;

    private final org.openqa.selenium.devtools.v129.network.model.PrivateNetworkRequestPolicy privateNetworkRequestPolicy;

    public ClientSecurityState(java.lang.Boolean initiatorIsSecureContext, org.openqa.selenium.devtools.v129.network.model.IPAddressSpace initiatorIPAddressSpace, org.openqa.selenium.devtools.v129.network.model.PrivateNetworkRequestPolicy privateNetworkRequestPolicy) {
        this.initiatorIsSecureContext = java.util.Objects.requireNonNull(initiatorIsSecureContext, "initiatorIsSecureContext is required");
        this.initiatorIPAddressSpace = java.util.Objects.requireNonNull(initiatorIPAddressSpace, "initiatorIPAddressSpace is required");
        this.privateNetworkRequestPolicy = java.util.Objects.requireNonNull(privateNetworkRequestPolicy, "privateNetworkRequestPolicy is required");
    }

    public java.lang.Boolean getInitiatorIsSecureContext() {
        return initiatorIsSecureContext;
    }

    public org.openqa.selenium.devtools.v129.network.model.IPAddressSpace getInitiatorIPAddressSpace() {
        return initiatorIPAddressSpace;
    }

    public org.openqa.selenium.devtools.v129.network.model.PrivateNetworkRequestPolicy getPrivateNetworkRequestPolicy() {
        return privateNetworkRequestPolicy;
    }

    private static ClientSecurityState fromJson(JsonInput input) {
        java.lang.Boolean initiatorIsSecureContext = false;
        org.openqa.selenium.devtools.v129.network.model.IPAddressSpace initiatorIPAddressSpace = null;
        org.openqa.selenium.devtools.v129.network.model.PrivateNetworkRequestPolicy privateNetworkRequestPolicy = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "initiatorIsSecureContext":
                    initiatorIsSecureContext = input.nextBoolean();
                    break;
                case "initiatorIPAddressSpace":
                    initiatorIPAddressSpace = input.read(org.openqa.selenium.devtools.v129.network.model.IPAddressSpace.class);
                    break;
                case "privateNetworkRequestPolicy":
                    privateNetworkRequestPolicy = input.read(org.openqa.selenium.devtools.v129.network.model.PrivateNetworkRequestPolicy.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ClientSecurityState(initiatorIsSecureContext, initiatorIPAddressSpace, privateNetworkRequestPolicy);
    }
}
