package org.openqa.selenium.devtools.v129.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Specificity:
 * https://drafts.csswg.org/selectors/#specificity-rules
 */
@org.openqa.selenium.Beta()
public class Specificity {

    private final java.lang.Integer a;

    private final java.lang.Integer b;

    private final java.lang.Integer c;

    public Specificity(java.lang.Integer a, java.lang.Integer b, java.lang.Integer c) {
        this.a = java.util.Objects.requireNonNull(a, "a is required");
        this.b = java.util.Objects.requireNonNull(b, "b is required");
        this.c = java.util.Objects.requireNonNull(c, "c is required");
    }

    /**
     * The a component, which represents the number of ID selectors.
     */
    public java.lang.Integer getA() {
        return a;
    }

    /**
     * The b component, which represents the number of class selectors, attributes selectors, and
     * pseudo-classes.
     */
    public java.lang.Integer getB() {
        return b;
    }

    /**
     * The c component, which represents the number of type selectors and pseudo-elements.
     */
    public java.lang.Integer getC() {
        return c;
    }

    private static Specificity fromJson(JsonInput input) {
        java.lang.Integer a = 0;
        java.lang.Integer b = 0;
        java.lang.Integer c = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "a":
                    a = input.nextNumber().intValue();
                    break;
                case "b":
                    b = input.nextNumber().intValue();
                    break;
                case "c":
                    c = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Specificity(a, b, c);
    }
}
