package org.openqa.selenium.devtools.v129.log;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Provides access to log entries.
 */
public class Log {

    /**
     * Clears the log.
     */
    public static Command<Void> clear() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Log.clear", Map.copyOf(params));
    }

    /**
     * Disables log domain, prevents further log entries from being reported to the client.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Log.disable", Map.copyOf(params));
    }

    /**
     * Enables log domain, sends the entries collected so far to the client by means of the
     * `entryAdded` notification.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Log.enable", Map.copyOf(params));
    }

    /**
     * start violation reporting.
     */
    public static Command<Void> startViolationsReport(java.util.List<org.openqa.selenium.devtools.v129.log.model.ViolationSetting> config) {
        java.util.Objects.requireNonNull(config, "config is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("config", config);
        return new Command<>("Log.startViolationsReport", Map.copyOf(params));
    }

    /**
     * Stop violation reporting.
     */
    public static Command<Void> stopViolationsReport() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Log.stopViolationsReport", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v129.log.model.LogEntry> entryAdded() {
        return new Event<>("Log.entryAdded", ConverterFunctions.map("entry", org.openqa.selenium.devtools.v129.log.model.LogEntry.class));
    }
}
