package org.openqa.selenium.devtools.v128.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The type of a frameNavigated event.
 */
@org.openqa.selenium.Beta()
public enum NavigationType {

    NAVIGATION("Navigation"), BACKFORWARDCACHERESTORE("BackForwardCacheRestore");

    private String value;

    NavigationType(String value) {
        this.value = value;
    }

    public static NavigationType fromString(String s) {
        return java.util.Arrays.stream(NavigationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within NavigationType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static NavigationType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
