package org.openqa.selenium.devtools.v128.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class IsolatedElementHighlightConfig {

    private final org.openqa.selenium.devtools.v128.overlay.model.IsolationModeHighlightConfig isolationModeHighlightConfig;

    private final org.openqa.selenium.devtools.v128.dom.model.NodeId nodeId;

    public IsolatedElementHighlightConfig(org.openqa.selenium.devtools.v128.overlay.model.IsolationModeHighlightConfig isolationModeHighlightConfig, org.openqa.selenium.devtools.v128.dom.model.NodeId nodeId) {
        this.isolationModeHighlightConfig = java.util.Objects.requireNonNull(isolationModeHighlightConfig, "isolationModeHighlightConfig is required");
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
    }

    /**
     * A descriptor for the highlight appearance of an element in isolation mode.
     */
    public org.openqa.selenium.devtools.v128.overlay.model.IsolationModeHighlightConfig getIsolationModeHighlightConfig() {
        return isolationModeHighlightConfig;
    }

    /**
     * Identifier of the isolated element to highlight.
     */
    public org.openqa.selenium.devtools.v128.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    private static IsolatedElementHighlightConfig fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v128.overlay.model.IsolationModeHighlightConfig isolationModeHighlightConfig = null;
        org.openqa.selenium.devtools.v128.dom.model.NodeId nodeId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "isolationModeHighlightConfig":
                    isolationModeHighlightConfig = input.read(org.openqa.selenium.devtools.v128.overlay.model.IsolationModeHighlightConfig.class);
                    break;
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v128.dom.model.NodeId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new IsolatedElementHighlightConfig(isolationModeHighlightConfig, nodeId);
    }
}
