package org.openqa.selenium.devtools.v126.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Pair of issuer origin and number of available (signed, but not used) Trust
 * Tokens from that issuer.
 */
@org.openqa.selenium.Beta()
public class TrustTokens {

    private final java.lang.String issuerOrigin;

    private final java.lang.Number count;

    public TrustTokens(java.lang.String issuerOrigin, java.lang.Number count) {
        this.issuerOrigin = java.util.Objects.requireNonNull(issuerOrigin, "issuerOrigin is required");
        this.count = java.util.Objects.requireNonNull(count, "count is required");
    }

    public java.lang.String getIssuerOrigin() {
        return issuerOrigin;
    }

    public java.lang.Number getCount() {
        return count;
    }

    private static TrustTokens fromJson(JsonInput input) {
        java.lang.String issuerOrigin = null;
        java.lang.Number count = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "issuerOrigin":
                    issuerOrigin = input.nextString();
                    break;
                case "count":
                    count = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TrustTokens(issuerOrigin, count);
    }
}
