package org.openqa.selenium.devtools.v126.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum StyleSheetLoadingIssueReason {

    LATEIMPORTRULE("LateImportRule"), REQUESTFAILED("RequestFailed");

    private String value;

    StyleSheetLoadingIssueReason(String value) {
        this.value = value;
    }

    public static StyleSheetLoadingIssueReason fromString(String s) {
        return java.util.Arrays.stream(StyleSheetLoadingIssueReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within StyleSheetLoadingIssueReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static StyleSheetLoadingIssueReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
