package org.openqa.selenium.devtools.v124.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Types of not restored reasons for back-forward cache.
 */
@org.openqa.selenium.Beta()
public enum BackForwardCacheNotRestoredReasonType {

    SUPPORTPENDING("SupportPending"), PAGESUPPORTNEEDED("PageSupportNeeded"), CIRCUMSTANTIAL("Circumstantial");

    private String value;

    BackForwardCacheNotRestoredReasonType(String value) {
        this.value = value;
    }

    public static BackForwardCacheNotRestoredReasonType fromString(String s) {
        return java.util.Arrays.stream(BackForwardCacheNotRestoredReasonType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within BackForwardCacheNotRestoredReasonType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static BackForwardCacheNotRestoredReasonType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
