/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v123.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v123.audits.model.PropertyRuleIssueReason;
import org.openqa.selenium.devtools.v123.audits.model.SourceCodeLocation;
import org.openqa.selenium.json.JsonInput;

public class PropertyRuleIssueDetails {
    private final SourceCodeLocation sourceCodeLocation;
    private final PropertyRuleIssueReason propertyRuleIssueReason;
    private final Optional<String> propertyValue;

    public PropertyRuleIssueDetails(SourceCodeLocation sourceCodeLocation, PropertyRuleIssueReason propertyRuleIssueReason, Optional<String> propertyValue) {
        this.sourceCodeLocation = Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.propertyRuleIssueReason = Objects.requireNonNull(propertyRuleIssueReason, "propertyRuleIssueReason is required");
        this.propertyValue = propertyValue;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public PropertyRuleIssueReason getPropertyRuleIssueReason() {
        return this.propertyRuleIssueReason;
    }

    public Optional<String> getPropertyValue() {
        return this.propertyValue;
    }

    private static PropertyRuleIssueDetails fromJson(JsonInput input) {
        SourceCodeLocation sourceCodeLocation = null;
        PropertyRuleIssueReason propertyRuleIssueReason = null;
        Optional<String> propertyValue = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "sourceCodeLocation": {
                    sourceCodeLocation = (SourceCodeLocation)input.read(SourceCodeLocation.class);
                    continue block10;
                }
                case "propertyRuleIssueReason": {
                    propertyRuleIssueReason = (PropertyRuleIssueReason)((Object)input.read(PropertyRuleIssueReason.class));
                    continue block10;
                }
                case "propertyValue": {
                    propertyValue = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PropertyRuleIssueDetails(sourceCodeLocation, propertyRuleIssueReason, propertyValue);
    }
}

