package org.openqa.selenium.devtools.v122.animation;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Animation {

    /**
     * Disables animation domain notifications.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Animation.disable", Map.copyOf(params));
    }

    /**
     * Enables animation domain notifications.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Animation.enable", Map.copyOf(params));
    }

    /**
     * Returns the current time of the an animation.
     */
    public static Command<java.lang.Number> getCurrentTime(java.lang.String id) {
        java.util.Objects.requireNonNull(id, "id is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("id", id);
        return new Command<>("Animation.getCurrentTime", Map.copyOf(params), ConverterFunctions.map("currentTime", java.lang.Number.class));
    }

    /**
     * Gets the playback rate of the document timeline.
     */
    public static Command<java.lang.Number> getPlaybackRate() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Animation.getPlaybackRate", Map.copyOf(params), ConverterFunctions.map("playbackRate", java.lang.Number.class));
    }

    /**
     * Releases a set of animations to no longer be manipulated.
     */
    public static Command<Void> releaseAnimations(java.util.List<java.lang.String> animations) {
        java.util.Objects.requireNonNull(animations, "animations is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("animations", animations);
        return new Command<>("Animation.releaseAnimations", Map.copyOf(params));
    }

    /**
     * Gets the remote object of the Animation.
     */
    public static Command<org.openqa.selenium.devtools.v122.runtime.model.RemoteObject> resolveAnimation(java.lang.String animationId) {
        java.util.Objects.requireNonNull(animationId, "animationId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("animationId", animationId);
        return new Command<>("Animation.resolveAnimation", Map.copyOf(params), ConverterFunctions.map("remoteObject", org.openqa.selenium.devtools.v122.runtime.model.RemoteObject.class));
    }

    /**
     * Seek a set of animations to a particular time within each animation.
     */
    public static Command<Void> seekAnimations(java.util.List<java.lang.String> animations, java.lang.Number currentTime) {
        java.util.Objects.requireNonNull(animations, "animations is required");
        java.util.Objects.requireNonNull(currentTime, "currentTime is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("animations", animations);
        params.put("currentTime", currentTime);
        return new Command<>("Animation.seekAnimations", Map.copyOf(params));
    }

    /**
     * Sets the paused state of a set of animations.
     */
    public static Command<Void> setPaused(java.util.List<java.lang.String> animations, java.lang.Boolean paused) {
        java.util.Objects.requireNonNull(animations, "animations is required");
        java.util.Objects.requireNonNull(paused, "paused is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("animations", animations);
        params.put("paused", paused);
        return new Command<>("Animation.setPaused", Map.copyOf(params));
    }

    /**
     * Sets the playback rate of the document timeline.
     */
    public static Command<Void> setPlaybackRate(java.lang.Number playbackRate) {
        java.util.Objects.requireNonNull(playbackRate, "playbackRate is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("playbackRate", playbackRate);
        return new Command<>("Animation.setPlaybackRate", Map.copyOf(params));
    }

    /**
     * Sets the timing of an animation node.
     */
    public static Command<Void> setTiming(java.lang.String animationId, java.lang.Number duration, java.lang.Number delay) {
        java.util.Objects.requireNonNull(animationId, "animationId is required");
        java.util.Objects.requireNonNull(duration, "duration is required");
        java.util.Objects.requireNonNull(delay, "delay is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("animationId", animationId);
        params.put("duration", duration);
        params.put("delay", delay);
        return new Command<>("Animation.setTiming", Map.copyOf(params));
    }

    public static Event<java.lang.String> animationCanceled() {
        return new Event<>("Animation.animationCanceled", ConverterFunctions.map("id", java.lang.String.class));
    }

    public static Event<java.lang.String> animationCreated() {
        return new Event<>("Animation.animationCreated", ConverterFunctions.map("id", java.lang.String.class));
    }

    public static Event<org.openqa.selenium.devtools.v122.animation.model.Animation> animationStarted() {
        return new Event<>("Animation.animationStarted", ConverterFunctions.map("animation", org.openqa.selenium.devtools.v122.animation.model.Animation.class));
    }
}
