/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.webaudio;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioListener;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioListenerWillBeDestroyed;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioNode;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioNodeWillBeDestroyed;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioParam;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioParamWillBeDestroyed;
import org.openqa.selenium.devtools.v122.webaudio.model.BaseAudioContext;
import org.openqa.selenium.devtools.v122.webaudio.model.ContextRealtimeData;
import org.openqa.selenium.devtools.v122.webaudio.model.GraphObjectId;
import org.openqa.selenium.devtools.v122.webaudio.model.NodeParamConnected;
import org.openqa.selenium.devtools.v122.webaudio.model.NodeParamDisconnected;
import org.openqa.selenium.devtools.v122.webaudio.model.NodesConnected;
import org.openqa.selenium.devtools.v122.webaudio.model.NodesDisconnected;

@Beta
public class WebAudio {
    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("WebAudio.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("WebAudio.disable", Map.copyOf(params));
    }

    public static Command<ContextRealtimeData> getRealtimeData(GraphObjectId contextId) {
        Objects.requireNonNull(contextId, "contextId is required");
        LinkedHashMap<String, GraphObjectId> params = new LinkedHashMap<String, GraphObjectId>();
        params.put("contextId", contextId);
        return new Command("WebAudio.getRealtimeData", Map.copyOf(params), ConverterFunctions.map((String)"realtimeData", ContextRealtimeData.class));
    }

    public static Event<BaseAudioContext> contextCreated() {
        return new Event("WebAudio.contextCreated", ConverterFunctions.map((String)"context", BaseAudioContext.class));
    }

    public static Event<GraphObjectId> contextWillBeDestroyed() {
        return new Event("WebAudio.contextWillBeDestroyed", ConverterFunctions.map((String)"contextId", GraphObjectId.class));
    }

    public static Event<BaseAudioContext> contextChanged() {
        return new Event("WebAudio.contextChanged", ConverterFunctions.map((String)"context", BaseAudioContext.class));
    }

    public static Event<AudioListener> audioListenerCreated() {
        return new Event("WebAudio.audioListenerCreated", ConverterFunctions.map((String)"listener", AudioListener.class));
    }

    public static Event<AudioListenerWillBeDestroyed> audioListenerWillBeDestroyed() {
        return new Event("WebAudio.audioListenerWillBeDestroyed", input -> (AudioListenerWillBeDestroyed)input.read(AudioListenerWillBeDestroyed.class));
    }

    public static Event<AudioNode> audioNodeCreated() {
        return new Event("WebAudio.audioNodeCreated", ConverterFunctions.map((String)"node", AudioNode.class));
    }

    public static Event<AudioNodeWillBeDestroyed> audioNodeWillBeDestroyed() {
        return new Event("WebAudio.audioNodeWillBeDestroyed", input -> (AudioNodeWillBeDestroyed)input.read(AudioNodeWillBeDestroyed.class));
    }

    public static Event<AudioParam> audioParamCreated() {
        return new Event("WebAudio.audioParamCreated", ConverterFunctions.map((String)"param", AudioParam.class));
    }

    public static Event<AudioParamWillBeDestroyed> audioParamWillBeDestroyed() {
        return new Event("WebAudio.audioParamWillBeDestroyed", input -> (AudioParamWillBeDestroyed)input.read(AudioParamWillBeDestroyed.class));
    }

    public static Event<NodesConnected> nodesConnected() {
        return new Event("WebAudio.nodesConnected", input -> (NodesConnected)input.read(NodesConnected.class));
    }

    public static Event<NodesDisconnected> nodesDisconnected() {
        return new Event("WebAudio.nodesDisconnected", input -> (NodesDisconnected)input.read(NodesDisconnected.class));
    }

    public static Event<NodeParamConnected> nodeParamConnected() {
        return new Event("WebAudio.nodeParamConnected", input -> (NodeParamConnected)input.read(NodeParamConnected.class));
    }

    public static Event<NodeParamDisconnected> nodeParamDisconnected() {
        return new Event("WebAudio.nodeParamDisconnected", input -> (NodeParamDisconnected)input.read(NodeParamDisconnected.class));
    }
}

