package org.openqa.selenium.devtools.v117.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS rule representation.
 */
public class CSSRule {

    private final java.util.Optional<org.openqa.selenium.devtools.v117.css.model.StyleSheetId> styleSheetId;

    private final org.openqa.selenium.devtools.v117.css.model.SelectorList selectorList;

    private final java.util.Optional<java.util.List<java.lang.String>> nestingSelectors;

    private final org.openqa.selenium.devtools.v117.css.model.StyleSheetOrigin origin;

    private final org.openqa.selenium.devtools.v117.css.model.CSSStyle style;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSMedia>> media;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSContainerQuery>> containerQueries;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSSupports>> supports;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSLayer>> layers;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSScope>> scopes;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSRuleType>> ruleTypes;

    public CSSRule(java.util.Optional<org.openqa.selenium.devtools.v117.css.model.StyleSheetId> styleSheetId, org.openqa.selenium.devtools.v117.css.model.SelectorList selectorList, java.util.Optional<java.util.List<java.lang.String>> nestingSelectors, org.openqa.selenium.devtools.v117.css.model.StyleSheetOrigin origin, org.openqa.selenium.devtools.v117.css.model.CSSStyle style, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSMedia>> media, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSContainerQuery>> containerQueries, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSSupports>> supports, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSLayer>> layers, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSScope>> scopes, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSRuleType>> ruleTypes) {
        this.styleSheetId = styleSheetId;
        this.selectorList = java.util.Objects.requireNonNull(selectorList, "selectorList is required");
        this.nestingSelectors = nestingSelectors;
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.style = java.util.Objects.requireNonNull(style, "style is required");
        this.media = media;
        this.containerQueries = containerQueries;
        this.supports = supports;
        this.layers = layers;
        this.scopes = scopes;
        this.ruleTypes = ruleTypes;
    }

    /**
     * The css style sheet identifier (absent for user agent stylesheet and user-specified
     * stylesheet rules) this rule came from.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v117.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * Rule selector data.
     */
    public org.openqa.selenium.devtools.v117.css.model.SelectorList getSelectorList() {
        return selectorList;
    }

    /**
     * Array of selectors from ancestor style rules, sorted by distance from the current rule.
     */
    @Beta()
    public java.util.Optional<java.util.List<java.lang.String>> getNestingSelectors() {
        return nestingSelectors;
    }

    /**
     * Parent stylesheet's origin.
     */
    public org.openqa.selenium.devtools.v117.css.model.StyleSheetOrigin getOrigin() {
        return origin;
    }

    /**
     * Associated style declaration.
     */
    public org.openqa.selenium.devtools.v117.css.model.CSSStyle getStyle() {
        return style;
    }

    /**
     * Media list array (for rules involving media queries). The array enumerates media queries
     * starting with the innermost one, going outwards.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSMedia>> getMedia() {
        return media;
    }

    /**
     * Container query list array (for rules involving container queries).
     * The array enumerates container queries starting with the innermost one, going outwards.
     */
    @Beta()
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSContainerQuery>> getContainerQueries() {
        return containerQueries;
    }

    /**
     * @supports CSS at-rule array.
     * The array enumerates @supports at-rules starting with the innermost one, going outwards.
     */
    @Beta()
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSSupports>> getSupports() {
        return supports;
    }

    /**
     * Cascade layer array. Contains the layer hierarchy that this rule belongs to starting
     * with the innermost layer and going outwards.
     */
    @Beta()
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSLayer>> getLayers() {
        return layers;
    }

    /**
     * @scope CSS at-rule array.
     * The array enumerates @scope at-rules starting with the innermost one, going outwards.
     */
    @Beta()
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSScope>> getScopes() {
        return scopes;
    }

    /**
     * The array keeps the types of ancestor CSSRules from the innermost going outwards.
     */
    @Beta()
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSRuleType>> getRuleTypes() {
        return ruleTypes;
    }

    private static CSSRule fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v117.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v117.css.model.SelectorList selectorList = null;
        java.util.Optional<java.util.List<java.lang.String>> nestingSelectors = java.util.Optional.empty();
        org.openqa.selenium.devtools.v117.css.model.StyleSheetOrigin origin = null;
        org.openqa.selenium.devtools.v117.css.model.CSSStyle style = null;
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSMedia>> media = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSContainerQuery>> containerQueries = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSSupports>> supports = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSLayer>> layers = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSScope>> scopes = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v117.css.model.CSSRuleType>> ruleTypes = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v117.css.model.StyleSheetId.class));
                    break;
                case "selectorList":
                    selectorList = input.read(org.openqa.selenium.devtools.v117.css.model.SelectorList.class);
                    break;
                case "nestingSelectors":
                    nestingSelectors = java.util.Optional.ofNullable(input.readArray(java.lang.String.class));
                    break;
                case "origin":
                    origin = input.read(org.openqa.selenium.devtools.v117.css.model.StyleSheetOrigin.class);
                    break;
                case "style":
                    style = input.read(org.openqa.selenium.devtools.v117.css.model.CSSStyle.class);
                    break;
                case "media":
                    media = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v117.css.model.CSSMedia.class));
                    break;
                case "containerQueries":
                    containerQueries = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v117.css.model.CSSContainerQuery.class));
                    break;
                case "supports":
                    supports = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v117.css.model.CSSSupports.class));
                    break;
                case "layers":
                    layers = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v117.css.model.CSSLayer.class));
                    break;
                case "scopes":
                    scopes = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v117.css.model.CSSScope.class));
                    break;
                case "ruleTypes":
                    ruleTypes = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v117.css.model.CSSRuleType.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSRule(styleSheetId, selectorList, nestingSelectors, origin, style, media, containerQueries, supports, layers, scopes, ruleTypes);
    }
}
