/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v116.overlay;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v116.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v116.dom.model.NodeId;
import org.openqa.selenium.devtools.v116.dom.model.Quad;
import org.openqa.selenium.devtools.v116.dom.model.RGBA;
import org.openqa.selenium.devtools.v116.overlay.model.ColorFormat;
import org.openqa.selenium.devtools.v116.overlay.model.ContainerQueryHighlightConfig;
import org.openqa.selenium.devtools.v116.overlay.model.FlexNodeHighlightConfig;
import org.openqa.selenium.devtools.v116.overlay.model.GridNodeHighlightConfig;
import org.openqa.selenium.devtools.v116.overlay.model.HighlightConfig;
import org.openqa.selenium.devtools.v116.overlay.model.HingeConfig;
import org.openqa.selenium.devtools.v116.overlay.model.InspectMode;
import org.openqa.selenium.devtools.v116.overlay.model.IsolatedElementHighlightConfig;
import org.openqa.selenium.devtools.v116.overlay.model.ScrollSnapHighlightConfig;
import org.openqa.selenium.devtools.v116.overlay.model.SourceOrderConfig;
import org.openqa.selenium.devtools.v116.page.model.FrameId;
import org.openqa.selenium.devtools.v116.page.model.Viewport;
import org.openqa.selenium.devtools.v116.runtime.model.RemoteObjectId;

@Beta
public class Overlay {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Overlay.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Overlay.enable", (Map)params.build());
    }

    public static Command<Map<String, Object>> getHighlightObjectForTest(NodeId nodeId, Optional<Boolean> includeDistance, Optional<Boolean> includeStyle, Optional<ColorFormat> colorFormat, Optional<Boolean> showAccessibilityInfo) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        includeDistance.ifPresent(p -> params.put((Object)"includeDistance", p));
        includeStyle.ifPresent(p -> params.put((Object)"includeStyle", p));
        colorFormat.ifPresent(p -> params.put((Object)"colorFormat", (Object)p));
        showAccessibilityInfo.ifPresent(p -> params.put((Object)"showAccessibilityInfo", p));
        return new Command("Overlay.getHighlightObjectForTest", (Map)params.build(), ConverterFunctions.map((String)"highlight", (Type)new TypeToken<Map<String, Object>>(){}.getType()));
    }

    public static Command<Map<String, Object>> getGridHighlightObjectsForTest(List<NodeId> nodeIds) {
        Objects.requireNonNull(nodeIds, "nodeIds is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeIds", nodeIds);
        return new Command("Overlay.getGridHighlightObjectsForTest", (Map)params.build(), ConverterFunctions.map((String)"highlights", (Type)new TypeToken<Map<String, Object>>(){}.getType()));
    }

    public static Command<Map<String, Object>> getSourceOrderHighlightObjectForTest(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("Overlay.getSourceOrderHighlightObjectForTest", (Map)params.build(), ConverterFunctions.map((String)"highlight", (Type)new TypeToken<Map<String, Object>>(){}.getType()));
    }

    public static Command<Void> hideHighlight() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Overlay.hideHighlight", (Map)params.build());
    }

    @Deprecated
    public static Command<Void> highlightFrame(FrameId frameId, Optional<RGBA> contentColor, Optional<RGBA> contentOutlineColor) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        contentColor.ifPresent(p -> params.put((Object)"contentColor", p));
        contentOutlineColor.ifPresent(p -> params.put((Object)"contentOutlineColor", p));
        return new Command("Overlay.highlightFrame", (Map)params.build());
    }

    public static Command<Void> highlightNode(HighlightConfig highlightConfig, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> selector) {
        Objects.requireNonNull(highlightConfig, "highlightConfig is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"highlightConfig", (Object)highlightConfig);
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        selector.ifPresent(p -> params.put((Object)"selector", p));
        return new Command("Overlay.highlightNode", (Map)params.build());
    }

    public static Command<Void> highlightQuad(Quad quad, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(quad, "quad is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"quad", (Object)quad);
        color.ifPresent(p -> params.put((Object)"color", p));
        outlineColor.ifPresent(p -> params.put((Object)"outlineColor", p));
        return new Command("Overlay.highlightQuad", (Map)params.build());
    }

    public static Command<Void> highlightRect(Integer x, Integer y, Integer width, Integer height, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        params.put((Object)"width", (Object)width);
        params.put((Object)"height", (Object)height);
        color.ifPresent(p -> params.put((Object)"color", p));
        outlineColor.ifPresent(p -> params.put((Object)"outlineColor", p));
        return new Command("Overlay.highlightRect", (Map)params.build());
    }

    public static Command<Void> highlightSourceOrder(SourceOrderConfig sourceOrderConfig, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        Objects.requireNonNull(sourceOrderConfig, "sourceOrderConfig is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"sourceOrderConfig", (Object)sourceOrderConfig);
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command("Overlay.highlightSourceOrder", (Map)params.build());
    }

    public static Command<Void> setInspectMode(InspectMode mode, Optional<HighlightConfig> highlightConfig) {
        Objects.requireNonNull(mode, "mode is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"mode", (Object)mode);
        highlightConfig.ifPresent(p -> params.put((Object)"highlightConfig", p));
        return new Command("Overlay.setInspectMode", (Map)params.build());
    }

    public static Command<Void> setShowAdHighlights(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command("Overlay.setShowAdHighlights", (Map)params.build());
    }

    public static Command<Void> setPausedInDebuggerMessage(Optional<String> message) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        message.ifPresent(p -> params.put((Object)"message", p));
        return new Command("Overlay.setPausedInDebuggerMessage", (Map)params.build());
    }

    public static Command<Void> setShowDebugBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command("Overlay.setShowDebugBorders", (Map)params.build());
    }

    public static Command<Void> setShowFPSCounter(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command("Overlay.setShowFPSCounter", (Map)params.build());
    }

    public static Command<Void> setShowGridOverlays(List<GridNodeHighlightConfig> gridNodeHighlightConfigs) {
        Objects.requireNonNull(gridNodeHighlightConfigs, "gridNodeHighlightConfigs is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"gridNodeHighlightConfigs", gridNodeHighlightConfigs);
        return new Command("Overlay.setShowGridOverlays", (Map)params.build());
    }

    public static Command<Void> setShowFlexOverlays(List<FlexNodeHighlightConfig> flexNodeHighlightConfigs) {
        Objects.requireNonNull(flexNodeHighlightConfigs, "flexNodeHighlightConfigs is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"flexNodeHighlightConfigs", flexNodeHighlightConfigs);
        return new Command("Overlay.setShowFlexOverlays", (Map)params.build());
    }

    public static Command<Void> setShowScrollSnapOverlays(List<ScrollSnapHighlightConfig> scrollSnapHighlightConfigs) {
        Objects.requireNonNull(scrollSnapHighlightConfigs, "scrollSnapHighlightConfigs is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"scrollSnapHighlightConfigs", scrollSnapHighlightConfigs);
        return new Command("Overlay.setShowScrollSnapOverlays", (Map)params.build());
    }

    public static Command<Void> setShowContainerQueryOverlays(List<ContainerQueryHighlightConfig> containerQueryHighlightConfigs) {
        Objects.requireNonNull(containerQueryHighlightConfigs, "containerQueryHighlightConfigs is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"containerQueryHighlightConfigs", containerQueryHighlightConfigs);
        return new Command("Overlay.setShowContainerQueryOverlays", (Map)params.build());
    }

    public static Command<Void> setShowPaintRects(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"result", (Object)result);
        return new Command("Overlay.setShowPaintRects", (Map)params.build());
    }

    public static Command<Void> setShowLayoutShiftRegions(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"result", (Object)result);
        return new Command("Overlay.setShowLayoutShiftRegions", (Map)params.build());
    }

    public static Command<Void> setShowScrollBottleneckRects(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command("Overlay.setShowScrollBottleneckRects", (Map)params.build());
    }

    @Deprecated
    public static Command<Void> setShowHitTestBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command("Overlay.setShowHitTestBorders", (Map)params.build());
    }

    public static Command<Void> setShowWebVitals(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command("Overlay.setShowWebVitals", (Map)params.build());
    }

    public static Command<Void> setShowViewportSizeOnResize(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command("Overlay.setShowViewportSizeOnResize", (Map)params.build());
    }

    public static Command<Void> setShowHinge(Optional<HingeConfig> hingeConfig) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        hingeConfig.ifPresent(p -> params.put((Object)"hingeConfig", p));
        return new Command("Overlay.setShowHinge", (Map)params.build());
    }

    public static Command<Void> setShowIsolatedElements(List<IsolatedElementHighlightConfig> isolatedElementHighlightConfigs) {
        Objects.requireNonNull(isolatedElementHighlightConfigs, "isolatedElementHighlightConfigs is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"isolatedElementHighlightConfigs", isolatedElementHighlightConfigs);
        return new Command("Overlay.setShowIsolatedElements", (Map)params.build());
    }

    public static Event<BackendNodeId> inspectNodeRequested() {
        return new Event("Overlay.inspectNodeRequested", ConverterFunctions.map((String)"backendNodeId", BackendNodeId.class));
    }

    public static Event<NodeId> nodeHighlightRequested() {
        return new Event("Overlay.nodeHighlightRequested", ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Event<Viewport> screenshotRequested() {
        return new Event("Overlay.screenshotRequested", ConverterFunctions.map((String)"viewport", Viewport.class));
    }

    public static Event<Void> inspectModeCanceled() {
        return new Event("Overlay.inspectModeCanceled", input -> null);
    }
}

