/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v116.systeminfo;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v116.systeminfo.model.GPUInfo;
import org.openqa.selenium.devtools.v116.systeminfo.model.ProcessInfo;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SystemInfo {
    public static Command<GetInfoResponse> getInfo() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("SystemInfo.getInfo", (Map)params.build(), input -> (GetInfoResponse)input.read(GetInfoResponse.class));
    }

    public static Command<Boolean> getFeatureState(String featureState) {
        Objects.requireNonNull(featureState, "featureState is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"featureState", (Object)featureState);
        return new Command("SystemInfo.getFeatureState", (Map)params.build(), ConverterFunctions.map((String)"featureEnabled", Boolean.class));
    }

    public static Command<List<ProcessInfo>> getProcessInfo() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("SystemInfo.getProcessInfo", (Map)params.build(), ConverterFunctions.map((String)"processInfo", (Type)new TypeToken<List<ProcessInfo>>(){}.getType()));
    }

    public static class GetInfoResponse {
        private final GPUInfo gpu;
        private final String modelName;
        private final String modelVersion;
        private final String commandLine;

        public GetInfoResponse(GPUInfo gpu, String modelName, String modelVersion, String commandLine) {
            this.gpu = Objects.requireNonNull(gpu, "gpu is required");
            this.modelName = Objects.requireNonNull(modelName, "modelName is required");
            this.modelVersion = Objects.requireNonNull(modelVersion, "modelVersion is required");
            this.commandLine = Objects.requireNonNull(commandLine, "commandLine is required");
        }

        public GPUInfo getGpu() {
            return this.gpu;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getModelVersion() {
            return this.modelVersion;
        }

        public String getCommandLine() {
            return this.commandLine;
        }

        private static GetInfoResponse fromJson(JsonInput input) {
            GPUInfo gpu = null;
            String modelName = null;
            String modelVersion = null;
            String commandLine = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "gpu": {
                        gpu = (GPUInfo)input.read(GPUInfo.class);
                        continue block12;
                    }
                    case "modelName": {
                        modelName = input.nextString();
                        continue block12;
                    }
                    case "modelVersion": {
                        modelVersion = input.nextString();
                        continue block12;
                    }
                    case "commandLine": {
                        commandLine = input.nextString();
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetInfoResponse(gpu, modelName, modelVersion, commandLine);
        }
    }
}

