/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v115.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v115.audits.model.GenericIssueErrorType;
import org.openqa.selenium.devtools.v115.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v115.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class GenericIssueDetails {
    private final GenericIssueErrorType errorType;
    private final Optional<FrameId> frameId;
    private final Optional<BackendNodeId> violatingNodeId;
    private final Optional<String> violatingNodeAttribute;

    public GenericIssueDetails(GenericIssueErrorType errorType, Optional<FrameId> frameId, Optional<BackendNodeId> violatingNodeId, Optional<String> violatingNodeAttribute) {
        this.errorType = Objects.requireNonNull(errorType, "errorType is required");
        this.frameId = frameId;
        this.violatingNodeId = violatingNodeId;
        this.violatingNodeAttribute = violatingNodeAttribute;
    }

    public GenericIssueErrorType getErrorType() {
        return this.errorType;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    public Optional<BackendNodeId> getViolatingNodeId() {
        return this.violatingNodeId;
    }

    public Optional<String> getViolatingNodeAttribute() {
        return this.violatingNodeAttribute;
    }

    private static GenericIssueDetails fromJson(JsonInput input) {
        GenericIssueErrorType errorType = null;
        Optional<FrameId> frameId = Optional.empty();
        Optional<BackendNodeId> violatingNodeId = Optional.empty();
        Optional<String> violatingNodeAttribute = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "errorType": {
                    errorType = (GenericIssueErrorType)((Object)input.read(GenericIssueErrorType.class));
                    continue block12;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block12;
                }
                case "violatingNodeId": {
                    violatingNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block12;
                }
                case "violatingNodeAttribute": {
                    violatingNodeAttribute = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new GenericIssueDetails(errorType, frameId, violatingNodeId, violatingNodeAttribute);
    }
}

