/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.webaudio.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ContextType {
    REALTIME("realtime"),
    OFFLINE("offline");

    private String value;

    private ContextType(String value) {
        this.value = value;
    }

    public static ContextType fromString(String s) {
        return Arrays.stream(ContextType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ContextType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ContextType fromJson(JsonInput input) {
        return ContextType.fromString(input.nextString());
    }
}

