/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum HeavyAdReason {
    NETWORKTOTALLIMIT("NetworkTotalLimit"),
    CPUTOTALLIMIT("CpuTotalLimit"),
    CPUPEAKLIMIT("CpuPeakLimit");

    private String value;

    private HeavyAdReason(String value) {
        this.value = value;
    }

    public static HeavyAdReason fromString(String s) {
        return Arrays.stream(HeavyAdReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within HeavyAdReason "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static HeavyAdReason fromJson(JsonInput input) {
        return HeavyAdReason.fromString(input.nextString());
    }
}

