package org.openqa.selenium.devtools.v113.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration data for the highlighting of page elements.
 */
public class HighlightConfig {

    private final java.util.Optional<java.lang.Boolean> showInfo;

    private final java.util.Optional<java.lang.Boolean> showStyles;

    private final java.util.Optional<java.lang.Boolean> showRulers;

    private final java.util.Optional<java.lang.Boolean> showAccessibilityInfo;

    private final java.util.Optional<java.lang.Boolean> showExtensionLines;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> contentColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> paddingColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> borderColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> marginColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> eventTargetColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> shapeColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> shapeMarginColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> cssGridColor;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ColorFormat> colorFormat;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.GridHighlightConfig> gridHighlightConfig;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.FlexContainerHighlightConfig> flexContainerHighlightConfig;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.FlexItemHighlightConfig> flexItemHighlightConfig;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ContrastAlgorithm> contrastAlgorithm;

    private final java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ContainerQueryContainerHighlightConfig> containerQueryContainerHighlightConfig;

    public HighlightConfig(java.util.Optional<java.lang.Boolean> showInfo, java.util.Optional<java.lang.Boolean> showStyles, java.util.Optional<java.lang.Boolean> showRulers, java.util.Optional<java.lang.Boolean> showAccessibilityInfo, java.util.Optional<java.lang.Boolean> showExtensionLines, java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> contentColor, java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> paddingColor, java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> borderColor, java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> marginColor, java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> eventTargetColor, java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> shapeColor, java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> shapeMarginColor, java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> cssGridColor, java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ColorFormat> colorFormat, java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.GridHighlightConfig> gridHighlightConfig, java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.FlexContainerHighlightConfig> flexContainerHighlightConfig, java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.FlexItemHighlightConfig> flexItemHighlightConfig, java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ContrastAlgorithm> contrastAlgorithm, java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ContainerQueryContainerHighlightConfig> containerQueryContainerHighlightConfig) {
        this.showInfo = showInfo;
        this.showStyles = showStyles;
        this.showRulers = showRulers;
        this.showAccessibilityInfo = showAccessibilityInfo;
        this.showExtensionLines = showExtensionLines;
        this.contentColor = contentColor;
        this.paddingColor = paddingColor;
        this.borderColor = borderColor;
        this.marginColor = marginColor;
        this.eventTargetColor = eventTargetColor;
        this.shapeColor = shapeColor;
        this.shapeMarginColor = shapeMarginColor;
        this.cssGridColor = cssGridColor;
        this.colorFormat = colorFormat;
        this.gridHighlightConfig = gridHighlightConfig;
        this.flexContainerHighlightConfig = flexContainerHighlightConfig;
        this.flexItemHighlightConfig = flexItemHighlightConfig;
        this.contrastAlgorithm = contrastAlgorithm;
        this.containerQueryContainerHighlightConfig = containerQueryContainerHighlightConfig;
    }

    /**
     * Whether the node info tooltip should be shown (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowInfo() {
        return showInfo;
    }

    /**
     * Whether the node styles in the tooltip (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowStyles() {
        return showStyles;
    }

    /**
     * Whether the rulers should be shown (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowRulers() {
        return showRulers;
    }

    /**
     * Whether the a11y info should be shown (default: true).
     */
    public java.util.Optional<java.lang.Boolean> getShowAccessibilityInfo() {
        return showAccessibilityInfo;
    }

    /**
     * Whether the extension lines from node to the rulers should be shown (default: false).
     */
    public java.util.Optional<java.lang.Boolean> getShowExtensionLines() {
        return showExtensionLines;
    }

    /**
     * The content box highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> getContentColor() {
        return contentColor;
    }

    /**
     * The padding highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> getPaddingColor() {
        return paddingColor;
    }

    /**
     * The border highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> getBorderColor() {
        return borderColor;
    }

    /**
     * The margin highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> getMarginColor() {
        return marginColor;
    }

    /**
     * The event target element highlight fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> getEventTargetColor() {
        return eventTargetColor;
    }

    /**
     * The shape outside fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> getShapeColor() {
        return shapeColor;
    }

    /**
     * The shape margin fill color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> getShapeMarginColor() {
        return shapeMarginColor;
    }

    /**
     * The grid layout color (default: transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> getCssGridColor() {
        return cssGridColor;
    }

    /**
     * The color format used to format color styles (default: hex).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ColorFormat> getColorFormat() {
        return colorFormat;
    }

    /**
     * The grid layout highlight configuration (default: all transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.GridHighlightConfig> getGridHighlightConfig() {
        return gridHighlightConfig;
    }

    /**
     * The flex container highlight configuration (default: all transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.FlexContainerHighlightConfig> getFlexContainerHighlightConfig() {
        return flexContainerHighlightConfig;
    }

    /**
     * The flex item highlight configuration (default: all transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.FlexItemHighlightConfig> getFlexItemHighlightConfig() {
        return flexItemHighlightConfig;
    }

    /**
     * The contrast algorithm to use for the contrast ratio (default: aa).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ContrastAlgorithm> getContrastAlgorithm() {
        return contrastAlgorithm;
    }

    /**
     * The container query container highlight configuration (default: all transparent).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ContainerQueryContainerHighlightConfig> getContainerQueryContainerHighlightConfig() {
        return containerQueryContainerHighlightConfig;
    }

    private static HighlightConfig fromJson(JsonInput input) {
        java.util.Optional<java.lang.Boolean> showInfo = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showStyles = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showRulers = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showAccessibilityInfo = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> showExtensionLines = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> contentColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> paddingColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> borderColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> marginColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> eventTargetColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> shapeColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> shapeMarginColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.dom.model.RGBA> cssGridColor = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ColorFormat> colorFormat = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.GridHighlightConfig> gridHighlightConfig = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.FlexContainerHighlightConfig> flexContainerHighlightConfig = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.FlexItemHighlightConfig> flexItemHighlightConfig = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ContrastAlgorithm> contrastAlgorithm = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v113.overlay.model.ContainerQueryContainerHighlightConfig> containerQueryContainerHighlightConfig = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "showInfo":
                    showInfo = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showStyles":
                    showStyles = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showRulers":
                    showRulers = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showAccessibilityInfo":
                    showAccessibilityInfo = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "showExtensionLines":
                    showExtensionLines = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "contentColor":
                    contentColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.dom.model.RGBA.class));
                    break;
                case "paddingColor":
                    paddingColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.dom.model.RGBA.class));
                    break;
                case "borderColor":
                    borderColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.dom.model.RGBA.class));
                    break;
                case "marginColor":
                    marginColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.dom.model.RGBA.class));
                    break;
                case "eventTargetColor":
                    eventTargetColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.dom.model.RGBA.class));
                    break;
                case "shapeColor":
                    shapeColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.dom.model.RGBA.class));
                    break;
                case "shapeMarginColor":
                    shapeMarginColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.dom.model.RGBA.class));
                    break;
                case "cssGridColor":
                    cssGridColor = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.dom.model.RGBA.class));
                    break;
                case "colorFormat":
                    colorFormat = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.overlay.model.ColorFormat.class));
                    break;
                case "gridHighlightConfig":
                    gridHighlightConfig = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.overlay.model.GridHighlightConfig.class));
                    break;
                case "flexContainerHighlightConfig":
                    flexContainerHighlightConfig = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.overlay.model.FlexContainerHighlightConfig.class));
                    break;
                case "flexItemHighlightConfig":
                    flexItemHighlightConfig = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.overlay.model.FlexItemHighlightConfig.class));
                    break;
                case "contrastAlgorithm":
                    contrastAlgorithm = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.overlay.model.ContrastAlgorithm.class));
                    break;
                case "containerQueryContainerHighlightConfig":
                    containerQueryContainerHighlightConfig = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v113.overlay.model.ContainerQueryContainerHighlightConfig.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new HighlightConfig(showInfo, showStyles, showRulers, showAccessibilityInfo, showExtensionLines, contentColor, paddingColor, borderColor, marginColor, eventTargetColor, shapeColor, shapeMarginColor, cssGridColor, colorFormat, gridHighlightConfig, flexContainerHighlightConfig, flexItemHighlightConfig, contrastAlgorithm, containerQueryContainerHighlightConfig);
    }
}
