package org.openqa.selenium.devtools.v113.deviceaccess;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class DeviceAccess {

    /**
     * Enable events in this domain.
     */
    public static Command<Void> enable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("DeviceAccess.enable", params.build());
    }

    /**
     * Disable events in this domain.
     */
    public static Command<Void> disable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("DeviceAccess.disable", params.build());
    }

    /**
     * Select a device in response to a DeviceAccess.deviceRequestPrompted event.
     */
    public static Command<Void> selectPrompt(org.openqa.selenium.devtools.v113.deviceaccess.model.RequestId id, org.openqa.selenium.devtools.v113.deviceaccess.model.DeviceId deviceId) {
        java.util.Objects.requireNonNull(id, "id is required");
        java.util.Objects.requireNonNull(deviceId, "deviceId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("id", id);
        params.put("deviceId", deviceId);
        return new Command<>("DeviceAccess.selectPrompt", params.build());
    }

    /**
     * Cancel a prompt in response to a DeviceAccess.deviceRequestPrompted event.
     */
    public static Command<Void> cancelPrompt(org.openqa.selenium.devtools.v113.deviceaccess.model.RequestId id) {
        java.util.Objects.requireNonNull(id, "id is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("id", id);
        return new Command<>("DeviceAccess.cancelPrompt", params.build());
    }

    public static Event<org.openqa.selenium.devtools.v113.deviceaccess.model.DeviceRequestPrompted> deviceRequestPrompted() {
        return new Event<>("DeviceAccess.deviceRequestPrompted", input -> input.read(org.openqa.selenium.devtools.v113.deviceaccess.model.DeviceRequestPrompted.class));
    }
}
