/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.page.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v112.page.model.FrameId;
import org.openqa.selenium.devtools.v112.page.model.PreloadingStatus;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PrefetchStatusUpdated {
    private final FrameId initiatingFrameId;
    private final String prefetchUrl;
    private final PreloadingStatus status;

    public PrefetchStatusUpdated(FrameId initiatingFrameId, String prefetchUrl, PreloadingStatus status) {
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prefetchUrl = Objects.requireNonNull(prefetchUrl, "prefetchUrl is required");
        this.status = Objects.requireNonNull(status, "status is required");
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrefetchUrl() {
        return this.prefetchUrl;
    }

    public PreloadingStatus getStatus() {
        return this.status;
    }

    private static PrefetchStatusUpdated fromJson(JsonInput input) {
        FrameId initiatingFrameId = null;
        String prefetchUrl = null;
        PreloadingStatus status = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read(FrameId.class);
                    continue block10;
                }
                case "prefetchUrl": {
                    prefetchUrl = input.nextString();
                    continue block10;
                }
                case "status": {
                    status = (PreloadingStatus)((Object)input.read(PreloadingStatus.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrefetchStatusUpdated(initiatingFrameId, prefetchUrl, status);
    }
}

