/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.dom.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v111.dom.model.BackendNode;
import org.openqa.selenium.devtools.v111.dom.model.NodeId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DistributedNodesUpdated {
    private final NodeId insertionPointId;
    private final List<BackendNode> distributedNodes;

    public DistributedNodesUpdated(NodeId insertionPointId, List<BackendNode> distributedNodes) {
        this.insertionPointId = Objects.requireNonNull(insertionPointId, "insertionPointId is required");
        this.distributedNodes = Objects.requireNonNull(distributedNodes, "distributedNodes is required");
    }

    public NodeId getInsertionPointId() {
        return this.insertionPointId;
    }

    public List<BackendNode> getDistributedNodes() {
        return this.distributedNodes;
    }

    private static DistributedNodesUpdated fromJson(JsonInput input) {
        NodeId insertionPointId = null;
        List distributedNodes = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "insertionPointId": {
                    insertionPointId = (NodeId)input.read(NodeId.class);
                    continue block8;
                }
                case "distributedNodes": {
                    distributedNodes = (List)input.read(new TypeToken<List<BackendNode>>(){}.getType());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DistributedNodesUpdated(insertionPointId, distributedNodes);
    }
}

