/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.css.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v111.css.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

public class RuleUsage {
    private final StyleSheetId styleSheetId;
    private final Number startOffset;
    private final Number endOffset;
    private final Boolean used;

    public RuleUsage(StyleSheetId styleSheetId, Number startOffset, Number endOffset, Boolean used) {
        this.styleSheetId = Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        this.startOffset = Objects.requireNonNull(startOffset, "startOffset is required");
        this.endOffset = Objects.requireNonNull(endOffset, "endOffset is required");
        this.used = Objects.requireNonNull(used, "used is required");
    }

    public StyleSheetId getStyleSheetId() {
        return this.styleSheetId;
    }

    public Number getStartOffset() {
        return this.startOffset;
    }

    public Number getEndOffset() {
        return this.endOffset;
    }

    public Boolean getUsed() {
        return this.used;
    }

    private static RuleUsage fromJson(JsonInput input) {
        StyleSheetId styleSheetId = null;
        Number startOffset = 0;
        Number endOffset = 0;
        Boolean used = false;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = (StyleSheetId)input.read(StyleSheetId.class);
                    continue block12;
                }
                case "startOffset": {
                    startOffset = input.nextNumber();
                    continue block12;
                }
                case "endOffset": {
                    endOffset = input.nextNumber();
                    continue block12;
                }
                case "used": {
                    used = input.nextBoolean();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RuleUsage(styleSheetId, startOffset, endOffset, used);
    }
}

