/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.network.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v110.network.model.IPAddressSpace;
import org.openqa.selenium.devtools.v110.network.model.PrivateNetworkRequestPolicy;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ClientSecurityState {
    private final Boolean initiatorIsSecureContext;
    private final IPAddressSpace initiatorIPAddressSpace;
    private final PrivateNetworkRequestPolicy privateNetworkRequestPolicy;

    public ClientSecurityState(Boolean initiatorIsSecureContext, IPAddressSpace initiatorIPAddressSpace, PrivateNetworkRequestPolicy privateNetworkRequestPolicy) {
        this.initiatorIsSecureContext = Objects.requireNonNull(initiatorIsSecureContext, "initiatorIsSecureContext is required");
        this.initiatorIPAddressSpace = Objects.requireNonNull(initiatorIPAddressSpace, "initiatorIPAddressSpace is required");
        this.privateNetworkRequestPolicy = Objects.requireNonNull(privateNetworkRequestPolicy, "privateNetworkRequestPolicy is required");
    }

    public Boolean getInitiatorIsSecureContext() {
        return this.initiatorIsSecureContext;
    }

    public IPAddressSpace getInitiatorIPAddressSpace() {
        return this.initiatorIPAddressSpace;
    }

    public PrivateNetworkRequestPolicy getPrivateNetworkRequestPolicy() {
        return this.privateNetworkRequestPolicy;
    }

    private static ClientSecurityState fromJson(JsonInput input) {
        Boolean initiatorIsSecureContext = false;
        IPAddressSpace initiatorIPAddressSpace = null;
        PrivateNetworkRequestPolicy privateNetworkRequestPolicy = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "initiatorIsSecureContext": {
                    initiatorIsSecureContext = input.nextBoolean();
                    continue block10;
                }
                case "initiatorIPAddressSpace": {
                    initiatorIPAddressSpace = (IPAddressSpace)((Object)input.read(IPAddressSpace.class));
                    continue block10;
                }
                case "privateNetworkRequestPolicy": {
                    privateNetworkRequestPolicy = (PrivateNetworkRequestPolicy)((Object)input.read(PrivateNetworkRequestPolicy.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ClientSecurityState(initiatorIsSecureContext, initiatorIPAddressSpace, privateNetworkRequestPolicy);
    }
}

