/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.heapprofiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v110.heapprofiler.model.HeapSnapshotObjectId;
import org.openqa.selenium.devtools.v110.heapprofiler.model.LastSeenObjectId;
import org.openqa.selenium.devtools.v110.heapprofiler.model.ReportHeapSnapshotProgress;
import org.openqa.selenium.devtools.v110.heapprofiler.model.SamplingHeapProfile;
import org.openqa.selenium.devtools.v110.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v110.runtime.model.RemoteObjectId;

@Beta
public class HeapProfiler {
    public static Command<Void> addInspectedHeapObject(HeapSnapshotObjectId heapObjectId) {
        Objects.requireNonNull(heapObjectId, "heapObjectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"heapObjectId", (Object)heapObjectId);
        return new Command("HeapProfiler.addInspectedHeapObject", (Map)params.build());
    }

    public static Command<Void> collectGarbage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("HeapProfiler.collectGarbage", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("HeapProfiler.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("HeapProfiler.enable", (Map)params.build());
    }

    public static Command<HeapSnapshotObjectId> getHeapObjectId(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        return new Command("HeapProfiler.getHeapObjectId", (Map)params.build(), ConverterFunctions.map((String)"heapSnapshotObjectId", HeapSnapshotObjectId.class));
    }

    public static Command<RemoteObject> getObjectByHeapObjectId(HeapSnapshotObjectId objectId, Optional<String> objectGroup) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        return new Command("HeapProfiler.getObjectByHeapObjectId", (Map)params.build(), ConverterFunctions.map((String)"result", RemoteObject.class));
    }

    public static Command<SamplingHeapProfile> getSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("HeapProfiler.getSamplingProfile", (Map)params.build(), ConverterFunctions.map((String)"profile", SamplingHeapProfile.class));
    }

    public static Command<Void> startSampling(Optional<Number> samplingInterval, Optional<Boolean> includeObjectsCollectedByMajorGC, Optional<Boolean> includeObjectsCollectedByMinorGC) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        samplingInterval.ifPresent(p -> params.put((Object)"samplingInterval", p));
        includeObjectsCollectedByMajorGC.ifPresent(p -> params.put((Object)"includeObjectsCollectedByMajorGC", p));
        includeObjectsCollectedByMinorGC.ifPresent(p -> params.put((Object)"includeObjectsCollectedByMinorGC", p));
        return new Command("HeapProfiler.startSampling", (Map)params.build());
    }

    public static Command<Void> startTrackingHeapObjects(Optional<Boolean> trackAllocations) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        trackAllocations.ifPresent(p -> params.put((Object)"trackAllocations", p));
        return new Command("HeapProfiler.startTrackingHeapObjects", (Map)params.build());
    }

    public static Command<SamplingHeapProfile> stopSampling() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("HeapProfiler.stopSampling", (Map)params.build(), ConverterFunctions.map((String)"profile", SamplingHeapProfile.class));
    }

    public static Command<Void> stopTrackingHeapObjects(Optional<Boolean> reportProgress, Optional<Boolean> treatGlobalObjectsAsRoots, Optional<Boolean> captureNumericValue, Optional<Boolean> exposeInternals) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        reportProgress.ifPresent(p -> params.put((Object)"reportProgress", p));
        treatGlobalObjectsAsRoots.ifPresent(p -> params.put((Object)"treatGlobalObjectsAsRoots", p));
        captureNumericValue.ifPresent(p -> params.put((Object)"captureNumericValue", p));
        exposeInternals.ifPresent(p -> params.put((Object)"exposeInternals", p));
        return new Command("HeapProfiler.stopTrackingHeapObjects", (Map)params.build());
    }

    public static Command<Void> takeHeapSnapshot(Optional<Boolean> reportProgress, Optional<Boolean> treatGlobalObjectsAsRoots, Optional<Boolean> captureNumericValue, Optional<Boolean> exposeInternals) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        reportProgress.ifPresent(p -> params.put((Object)"reportProgress", p));
        treatGlobalObjectsAsRoots.ifPresent(p -> params.put((Object)"treatGlobalObjectsAsRoots", p));
        captureNumericValue.ifPresent(p -> params.put((Object)"captureNumericValue", p));
        exposeInternals.ifPresent(p -> params.put((Object)"exposeInternals", p));
        return new Command("HeapProfiler.takeHeapSnapshot", (Map)params.build());
    }

    public static Event<String> addHeapSnapshotChunk() {
        return new Event("HeapProfiler.addHeapSnapshotChunk", ConverterFunctions.map((String)"chunk", String.class));
    }

    public static Event<List<Integer>> heapStatsUpdate() {
        return new Event("HeapProfiler.heapStatsUpdate", ConverterFunctions.map((String)"statsUpdate", (Type)new TypeToken<List<Integer>>(){}.getType()));
    }

    public static Event<LastSeenObjectId> lastSeenObjectId() {
        return new Event("HeapProfiler.lastSeenObjectId", input -> (LastSeenObjectId)input.read(LastSeenObjectId.class));
    }

    public static Event<ReportHeapSnapshotProgress> reportHeapSnapshotProgress() {
        return new Event("HeapProfiler.reportHeapSnapshotProgress", input -> (ReportHeapSnapshotProgress)input.read(ReportHeapSnapshotProgress.class));
    }

    public static Event<Void> resetProfiles() {
        return new Event("HeapProfiler.resetProfiles", input -> null);
    }
}

