package org.openqa.selenium.devtools.v110.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Bundles the parameters for shared storage access events whose
 * presence/absence can vary according to SharedStorageAccessType.
 */
public class SharedStorageAccessParams {

    private final java.util.Optional<java.lang.String> scriptSourceUrl;

    private final java.util.Optional<java.lang.String> operationName;

    private final java.util.Optional<java.lang.String> serializedData;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v110.storage.model.SharedStorageUrlWithMetadata>> urlsWithMetadata;

    private final java.util.Optional<java.lang.String> key;

    private final java.util.Optional<java.lang.String> value;

    private final java.util.Optional<java.lang.Boolean> ignoreIfPresent;

    public SharedStorageAccessParams(java.util.Optional<java.lang.String> scriptSourceUrl, java.util.Optional<java.lang.String> operationName, java.util.Optional<java.lang.String> serializedData, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v110.storage.model.SharedStorageUrlWithMetadata>> urlsWithMetadata, java.util.Optional<java.lang.String> key, java.util.Optional<java.lang.String> value, java.util.Optional<java.lang.Boolean> ignoreIfPresent) {
        this.scriptSourceUrl = scriptSourceUrl;
        this.operationName = operationName;
        this.serializedData = serializedData;
        this.urlsWithMetadata = urlsWithMetadata;
        this.key = key;
        this.value = value;
        this.ignoreIfPresent = ignoreIfPresent;
    }

    /**
     * Spec of the module script URL.
     * Present only for SharedStorageAccessType.documentAddModule.
     */
    public java.util.Optional<java.lang.String> getScriptSourceUrl() {
        return scriptSourceUrl;
    }

    /**
     * Name of the registered operation to be run.
     * Present only for SharedStorageAccessType.documentRun and
     * SharedStorageAccessType.documentSelectURL.
     */
    public java.util.Optional<java.lang.String> getOperationName() {
        return operationName;
    }

    /**
     * The operation's serialized data in bytes (converted to a string).
     * Present only for SharedStorageAccessType.documentRun and
     * SharedStorageAccessType.documentSelectURL.
     */
    public java.util.Optional<java.lang.String> getSerializedData() {
        return serializedData;
    }

    /**
     * Array of candidate URLs' specs, along with any associated metadata.
     * Present only for SharedStorageAccessType.documentSelectURL.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v110.storage.model.SharedStorageUrlWithMetadata>> getUrlsWithMetadata() {
        return urlsWithMetadata;
    }

    /**
     * Key for a specific entry in an origin's shared storage.
     * Present only for SharedStorageAccessType.documentSet,
     * SharedStorageAccessType.documentAppend,
     * SharedStorageAccessType.documentDelete,
     * SharedStorageAccessType.workletSet,
     * SharedStorageAccessType.workletAppend,
     * SharedStorageAccessType.workletDelete, and
     * SharedStorageAccessType.workletGet.
     */
    public java.util.Optional<java.lang.String> getKey() {
        return key;
    }

    /**
     * Value for a specific entry in an origin's shared storage.
     * Present only for SharedStorageAccessType.documentSet,
     * SharedStorageAccessType.documentAppend,
     * SharedStorageAccessType.workletSet, and
     * SharedStorageAccessType.workletAppend.
     */
    public java.util.Optional<java.lang.String> getValue() {
        return value;
    }

    /**
     * Whether or not to set an entry for a key if that key is already present.
     * Present only for SharedStorageAccessType.documentSet and
     * SharedStorageAccessType.workletSet.
     */
    public java.util.Optional<java.lang.Boolean> getIgnoreIfPresent() {
        return ignoreIfPresent;
    }

    private static SharedStorageAccessParams fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> scriptSourceUrl = java.util.Optional.empty();
        java.util.Optional<java.lang.String> operationName = java.util.Optional.empty();
        java.util.Optional<java.lang.String> serializedData = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v110.storage.model.SharedStorageUrlWithMetadata>> urlsWithMetadata = java.util.Optional.empty();
        java.util.Optional<java.lang.String> key = java.util.Optional.empty();
        java.util.Optional<java.lang.String> value = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> ignoreIfPresent = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "scriptSourceUrl":
                    scriptSourceUrl = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "operationName":
                    operationName = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "serializedData":
                    serializedData = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "urlsWithMetadata":
                    urlsWithMetadata = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v110.storage.model.SharedStorageUrlWithMetadata>>() {
                    }.getType()));
                    break;
                case "key":
                    key = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "value":
                    value = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "ignoreIfPresent":
                    ignoreIfPresent = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageAccessParams(scriptSourceUrl, operationName, serializedData, urlsWithMetadata, key, value, ignoreIfPresent);
    }
}
