package org.openqa.selenium.devtools.v108.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when page is about to start a download.
 * Deprecated. Use Browser.downloadWillBegin instead.
 */
@org.openqa.selenium.Beta()
@java.lang.Deprecated()
public class DownloadWillBegin {

    private final org.openqa.selenium.devtools.v108.page.model.FrameId frameId;

    private final java.lang.String guid;

    private final java.lang.String url;

    private final java.lang.String suggestedFilename;

    public DownloadWillBegin(org.openqa.selenium.devtools.v108.page.model.FrameId frameId, java.lang.String guid, java.lang.String url, java.lang.String suggestedFilename) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.guid = java.util.Objects.requireNonNull(guid, "guid is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.suggestedFilename = java.util.Objects.requireNonNull(suggestedFilename, "suggestedFilename is required");
    }

    /**
     * Id of the frame that caused download to begin.
     */
    public org.openqa.selenium.devtools.v108.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Global unique identifier of the download.
     */
    public java.lang.String getGuid() {
        return guid;
    }

    /**
     * URL of the resource being downloaded.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Suggested file name of the resource (the actual name of the file saved on disk may differ).
     */
    public java.lang.String getSuggestedFilename() {
        return suggestedFilename;
    }

    private static DownloadWillBegin fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v108.page.model.FrameId frameId = null;
        java.lang.String guid = null;
        java.lang.String url = null;
        java.lang.String suggestedFilename = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v108.page.model.FrameId.class);
                    break;
                case "guid":
                    guid = input.nextString();
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "suggestedFilename":
                    suggestedFilename = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DownloadWillBegin(frameId, guid, url, suggestedFilename);
    }
}
