/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.overlay.model;

import java.util.Arrays;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v106.dom.model.RGBA;
import org.openqa.selenium.json.JsonInput;

public class LineStyle {
    private final Optional<RGBA> color;
    private final Optional<Pattern> pattern;

    public LineStyle(Optional<RGBA> color, Optional<Pattern> pattern) {
        this.color = color;
        this.pattern = pattern;
    }

    public Optional<RGBA> getColor() {
        return this.color;
    }

    public Optional<Pattern> getPattern() {
        return this.pattern;
    }

    private static LineStyle fromJson(JsonInput input) {
        Optional<RGBA> color = Optional.empty();
        Optional<Pattern> pattern = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "color": {
                    color = Optional.ofNullable((RGBA)input.read(RGBA.class));
                    continue block8;
                }
                case "pattern": {
                    pattern = Optional.ofNullable(Pattern.fromString(input.nextString()));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LineStyle(color, pattern);
    }

    public static enum Pattern {
        DASHED("dashed"),
        DOTTED("dotted");

        private String value;

        private Pattern(String value) {
            this.value = value;
        }

        public static Pattern fromString(String s) {
            return Arrays.stream(Pattern.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Pattern "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Pattern fromJson(JsonInput input) {
            return Pattern.fromString(input.nextString());
        }
    }
}

