/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.logging.Level;
import org.json.JSONObject;

public class LogEntry {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final Level level;
    private final long timestamp;
    private final String message;

    public LogEntry(Level level, long timestamp, String message) {
        this.level = level;
        this.timestamp = timestamp;
        this.message = message;
    }

    public Level getLevel() {
        return this.level;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.format("[%s] [%s] %s", DATE_FORMAT.format(new Date(this.timestamp)), this.level, this.message);
    }

    public JSONObject toJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", this.timestamp);
        map.put("level", this.level);
        map.put("message", this.message);
        return new JSONObject(map);
    }
}

