/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ReverseProxyHandler
implements CommandHandler {
    private static final Logger LOG = Logger.getLogger(ReverseProxyHandler.class.getName());
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ImmutableSet.builder().add((Object)"connection").add((Object)"keep-alive").add((Object)"proxy-authorization").add((Object)"proxy-authenticate").add((Object)"proxy-connection").add((Object)"te").add((Object)"trailer").add((Object)"transfer-encoding").add((Object)"upgrade").build();
    private final HttpClient upstream;

    public ReverseProxyHandler(HttpClient httpClient) {
        this.upstream = Objects.requireNonNull(httpClient, "HTTP client to use must be set.");
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        HttpRequest toUpstream = new HttpRequest(req.getMethod(), req.getUri());
        for (String name : req.getQueryParameterNames()) {
            for (String value : req.getQueryParameters(name)) {
                toUpstream.addQueryParameter(name, value);
            }
        }
        for (String name : req.getHeaderNames()) {
            if (IGNORED_REQ_HEADERS.contains((Object)name.toLowerCase())) continue;
            for (String value : req.getHeaders(name)) {
                toUpstream.addHeader(name, value);
            }
        }
        toUpstream.setHeader("Connection", "keep-alive");
        toUpstream.setContent(req.getContent());
        HttpResponse fromUpstream = this.upstream.execute(toUpstream);
        resp.setStatus(fromUpstream.getStatus());
        resp.setHeader("Date", null);
        resp.setHeader("Server", null);
        for (String name : fromUpstream.getHeaderNames()) {
            if (IGNORED_REQ_HEADERS.contains((Object)name)) continue;
            for (String value : fromUpstream.getHeaders(name)) {
                if (value == null) continue;
                resp.addHeader(name, value);
            }
        }
        resp.setContent(fromUpstream.getContent());
    }
}

