/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.NoHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class CombinedHandler
implements Predicate<HttpRequest>,
CommandHandler {
    private final Map<Predicate<HttpRequest>, CommandHandler> handlers = new HashMap<Predicate<HttpRequest>, CommandHandler>();

    public <X extends Predicate<HttpRequest> & CommandHandler> void addHandler(X handler) {
        this.handlers.put(handler, handler);
    }

    @Override
    public boolean test(HttpRequest request) {
        return this.handlers.keySet().stream().map(p -> p.test(request)).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        this.handlers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(req)).findFirst().map(Map.Entry::getValue).orElse(new NoHandler(new Json())).execute(req, resp);
    }
}

