/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.remote;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.DistributedTracer;
import org.openqa.selenium.remote.tracing.Span;

public class RemoteNode
extends Node {
    public static final Json JSON = new Json();
    private final Function<HttpRequest, HttpResponse> client;
    private final URI externalUri;
    private final Set<Capabilities> capabilities;
    private final HealthCheck healthCheck;

    public RemoteNode(DistributedTracer tracer, HttpClient.Factory clientFactory, UUID id, URI externalUri, Collection<Capabilities> capabilities) {
        super(tracer, id, externalUri);
        this.externalUri = Objects.requireNonNull(externalUri);
        this.capabilities = ImmutableSet.copyOf(capabilities);
        HttpClient client = Objects.requireNonNull(clientFactory).createClient(Urls.fromUri((URI)externalUri));
        this.client = req -> {
            try {
                return client.execute(req);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        this.healthCheck = new RemoteCheck();
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.capabilities.stream().anyMatch(caps -> caps.getCapabilityNames().stream().allMatch(name -> Objects.equals(caps.getCapability(name), capabilities.getCapability(name))));
    }

    @Override
    public Optional<CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        Objects.requireNonNull(sessionRequest, "Capabilities for session are not set");
        HttpRequest req = new HttpRequest(HttpMethod.POST, "/se/grid/node/session");
        req.setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)sessionRequest)));
        HttpResponse res = this.client.apply(req);
        return Optional.ofNullable(Values.get(res, CreateSessionResponse.class));
    }

    @Override
    protected boolean isSessionOwner(SessionId id) {
        Objects.requireNonNull(id, "Session ID has not been set");
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/se/grid/node/owner/" + id);
        HttpResponse res = this.client.apply(req);
        return Values.get(res, Boolean.class) == Boolean.TRUE;
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Objects.requireNonNull(id, "Session ID has not been set");
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/se/grid/node/session/" + id);
        HttpResponse res = this.client.apply(req);
        return (Session)Values.get(res, Session.class);
    }

    @Override
    public void executeWebDriverCommand(HttpRequest req, HttpResponse resp) {
        HttpResponse fromUpstream = this.client.apply(req);
        resp.setStatus(fromUpstream.getStatus());
        for (String name : fromUpstream.getHeaderNames()) {
            for (String value : fromUpstream.getHeaders(name)) {
                resp.addHeader(name, value);
            }
        }
        resp.setContent(fromUpstream.getContent());
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        Objects.requireNonNull(id, "Session ID has not been set");
        HttpRequest req = new HttpRequest(HttpMethod.DELETE, "/se/grid/node/session/" + id);
        HttpResponse res = this.client.apply(req);
        Values.get(res, Void.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeStatus getStatus() {
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/status");
        HttpResponse res = this.client.apply(req);
        try (Reader reader = Contents.reader((HttpMessage)res);
             JsonInput in = JSON.newInput(reader);){
            in.beginObject();
            while (in.hasNext()) {
                if ("value".equals(in.nextName())) {
                    in.beginObject();
                } else {
                    in.skipValue();
                    continue;
                }
                while (in.hasNext()) {
                    if ("node".equals(in.nextName())) {
                        NodeStatus nodeStatus = (NodeStatus)in.read(NodeStatus.class);
                        return nodeStatus;
                    }
                    in.skipValue();
                }
                in.endObject();
            }
            throw new IllegalStateException("Unable to read status");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"id", (Object)this.getId(), (Object)"uri", (Object)this.externalUri, (Object)"capabilities", this.capabilities);
    }

    private class RemoteCheck
    implements HealthCheck {
        private RemoteCheck() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public HealthCheck.Result check() {
            HttpRequest req = new HttpRequest(HttpMethod.GET, "/status");
            try (Span span = RemoteNode.this.tracer.createSpan("node.health-check", null);){
                span.addTag("http.url", (Object)req.getUri());
                span.addTag("http.method", (Object)req.getMethod());
                span.addTag("node.id", (Object)RemoteNode.this.getId());
                HttpResponse res = (HttpResponse)RemoteNode.this.client.apply(req);
                span.addTag("http.code", (Number)res.getStatus());
                if (res.getStatus() == 200) {
                    span.addTag("health-check", true);
                    HealthCheck.Result result2 = new HealthCheck.Result(true, RemoteNode.this.externalUri + " is ok");
                    return result2;
                }
                span.addTag("health-check", false);
                HealthCheck.Result result = new HealthCheck.Result(false, String.format("An error occurred reading the status of %s: %s", RemoteNode.this.externalUri, Contents.string((HttpMessage)res)));
                return result;
            }
            catch (RuntimeException e) {
                return new HealthCheck.Result(false, "Unable to determine node status: " + e.getMessage());
            }
        }
    }
}

