/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import java.util.Objects;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.node.remote.RemoteNode;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.DistributedTracer;

public class AddNode
implements CommandHandler {
    private final DistributedTracer tracer;
    private final Distributor distributor;
    private final Json json;
    private final HttpClient.Factory httpFactory;

    public AddNode(DistributedTracer tracer, Distributor distributor, Json json, HttpClient.Factory httpFactory) {
        this.tracer = Objects.requireNonNull(tracer);
        this.distributor = Objects.requireNonNull(distributor);
        this.json = Objects.requireNonNull(json);
        this.httpFactory = Objects.requireNonNull(httpFactory);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) {
        NodeStatus status = (NodeStatus)this.json.toType(Contents.string((HttpMessage)req), NodeStatus.class);
        RemoteNode node = new RemoteNode(this.tracer, this.httpFactory, status.getNodeId(), status.getUri(), status.getStereotypes().keySet());
        this.distributor.add(node);
    }
}

