module org.openqa.selenium.grid {
    requires com.google.common;
    requires io.opentracing.noop;
    requires org.openqa.selenium.support;
    requires org.seleniumhq.jetty9;
    /* transitive */ requires java.logging;
    /* transitive */ requires javax.servlet.api;
    /* transitive */ requires jcommander;
    /* transitive */ requires jeromq;
    /* transitive */ requires io.opentracing.api;
    /* transitive */ requires org.openqa.selenium.core;
    /* transitive */ requires org.openqa.selenium.remote;

    exports org.openqa.selenium.cli;
    exports org.openqa.selenium.concurrent;
    exports org.openqa.selenium.docker;
    exports org.openqa.selenium.events;
    exports org.openqa.selenium.events.local;
    exports org.openqa.selenium.events.zeromq;
    exports org.openqa.selenium.grid;
    exports org.openqa.selenium.grid.commands;
    exports org.openqa.selenium.grid.component;
    exports org.openqa.selenium.grid.config;
    exports org.openqa.selenium.grid.data;
    exports org.openqa.selenium.grid.distributor;
    exports org.openqa.selenium.grid.distributor.config;
    exports org.openqa.selenium.grid.distributor.httpd;
    exports org.openqa.selenium.grid.distributor.local;
    exports org.openqa.selenium.grid.distributor.remote;
    exports org.openqa.selenium.grid.docker;
    exports org.openqa.selenium.grid.log;
    exports org.openqa.selenium.grid.node;
    exports org.openqa.selenium.grid.node.config;
    exports org.openqa.selenium.grid.node.httpd;
    exports org.openqa.selenium.grid.node.local;
    exports org.openqa.selenium.grid.node.remote;
    exports org.openqa.selenium.grid.router;
    exports org.openqa.selenium.grid.router.httpd;
    exports org.openqa.selenium.grid.server;
    exports org.openqa.selenium.grid.session;
    exports org.openqa.selenium.grid.session.remote;
    exports org.openqa.selenium.grid.sessionmap;
    exports org.openqa.selenium.grid.sessionmap.config;
    exports org.openqa.selenium.grid.sessionmap.httpd;
    exports org.openqa.selenium.grid.sessionmap.local;
    exports org.openqa.selenium.grid.sessionmap.remote;
    exports org.openqa.selenium.grid.web;
    exports org.openqa.selenium.remote.server.jmx;

    provides CliCommand with Hub, Standalone, DistributorServer, NodeServer, RouterServer, SessionMapServer;

}

