/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import metaconfig.Configured$;
import org.scalafmt.CompatCollections$;
import org.scalafmt.Error;
import org.scalafmt.Formatted;
import org.scalafmt.Scalafmt$;
import org.scalafmt.Versions$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.FailedToFormat;
import org.scalafmt.cli.InputMethod;
import org.scalafmt.cli.ScalafmtRunner;
import org.scalafmt.cli.TermDisplay;
import org.scalafmt.config.ProjectFiles;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.util.AbsoluteFile;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.collection.parallel.CollectionConverters;
import scala.meta.internal.tokenizers.PlatformTokenizerCache$;
import scala.meta.parsers.ParseException;
import scala.meta.tokenizers.TokenizeException;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

public final class ScalafmtCoreRunner$
implements ScalafmtRunner {
    public static final ScalafmtCoreRunner$ MODULE$ = new ScalafmtCoreRunner$();

    static {
        ScalafmtRunner.$init$(MODULE$);
    }

    @Override
    public TermDisplay newTermDisplay(CliOptions options, Seq<InputMethod> inputMethods, String msg) {
        return ScalafmtRunner.newTermDisplay$(this, options, inputMethods, msg);
    }

    @Override
    public Seq<InputMethod> getInputMethods(CliOptions options, Function1<AbsoluteFile, Object> filter) {
        return ScalafmtRunner.getInputMethods$(this, options, filter);
    }

    @Override
    public ExitCode run(CliOptions options, String termDisplayMessage) {
        return (ExitCode)Configured$.MODULE$.ConfiguredImplicit(options.scalafmtConfig()).fold((Function1 & Serializable)e -> {
            options.common().err().println(String.valueOf(e.msg()));
            return ExitCode$.MODULE$.UnexpectedError();
        }, (Function1 & Serializable)scalafmtConf -> {
            options.common().debug().println(new StringBuilder(17).append("parsed config (v").append(Versions$.MODULE$.version()).append(")").toString());
            ProjectFiles.FileMatcher filterMatcher = ProjectFiles.FileMatcher$.MODULE$.apply(scalafmtConf.project(), options.customExcludes());
            Seq<InputMethod> inputMethods = MODULE$.getInputMethods(options, (Function1<AbsoluteFile, Object>)(Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)filterMatcher.matchesFile(file)));
            if (inputMethods.isEmpty() && options.mode().isEmpty() && !options.stdIn()) {
                throw Error.NoMatchingFiles$.MODULE$;
            }
            AtomicInteger counter = new AtomicInteger();
            TermDisplay termDisplay = MODULE$.newTermDisplay(options, inputMethods, termDisplayMessage);
            AtomicReference<ExitCode> exitCode = new AtomicReference<ExitCode>(ExitCode$.MODULE$.Ok());
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> CollectionConverters.ImmutableSeqIsParallelizable$.MODULE$.par$extension(CompatCollections$.MODULE$.ParConverters().ImmutableSeqIsParallelizable(inputMethods)).foreach((Function1 & Serializable)inputMethod -> {
                ScalafmtCoreRunner$.$anonfun$run$5(options, scalafmtConf, exitCode, termDisplay, termDisplayMessage, counter, inputMethod);
                return BoxedUnit.UNIT;
            }));
            termDisplay.completedTask(termDisplayMessage, exitCode.get().isOk());
            termDisplay.stop();
            return exitCode.get();
        });
    }

    private ExitCode handleFile(InputMethod inputMethod, CliOptions options, ScalafmtConfig config) {
        ExitCode exitCode;
        try {
            exitCode = this.unsafeHandleFile(inputMethod, options, config);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof Error.MisformattedFile)) {
                throw throwable;
            }
            Error.MisformattedFile misformattedFile = (Error.MisformattedFile)throwable2;
            String diff = misformattedFile.customMessage();
            options.common().err().println(diff);
            ExitCode exitCode2 = ExitCode$.MODULE$.TestError();
            exitCode = exitCode2;
        }
        return exitCode;
    }

    private ExitCode unsafeHandleFile(InputMethod inputMethod, CliOptions options, ScalafmtConfig scalafmtConfig) {
        ExitCode exitCode;
        String input = inputMethod.readInput(options);
        Formatted.Result formatResult = Scalafmt$.MODULE$.formatCode(input, scalafmtConfig, options.range(), inputMethod.filename());
        Formatted formatted = formatResult.formatted();
        if (formatted instanceof Formatted.Success) {
            Formatted.Success success = (Formatted.Success)formatted;
            String formatted2 = success.formattedCode();
            exitCode = inputMethod.write(formatted2, input, options);
        } else if (formatted instanceof Formatted.Failure) {
            ExitCode exitCode2;
            Formatted.Failure failure = (Formatted.Failure)formatted;
            Throwable e = failure.e();
            if (scalafmtConfig.runner().ignoreWarnings()) {
                exitCode2 = ExitCode$.MODULE$.Ok();
            } else {
                ExitCode exitCode3;
                Throwable throwable = e;
                boolean bl = throwable instanceof ParseException ? true : throwable instanceof TokenizeException;
                if (bl) {
                    options.common().err().println(throwable.toString());
                    exitCode3 = ExitCode$.MODULE$.ParseError();
                } else {
                    new FailedToFormat(inputMethod.filename(), e).printStackTrace(options.common().out());
                    exitCode3 = ExitCode$.MODULE$.UnexpectedError();
                }
                exitCode2 = exitCode3;
            }
            exitCode = exitCode2;
        } else {
            throw new MatchError((Object)formatted);
        }
        return exitCode;
    }

    public static final /* synthetic */ void $anonfun$run$5(CliOptions options$1, ScalafmtConfig scalafmtConf$1, AtomicReference exitCode$1, TermDisplay termDisplay$1, String termDisplayMessage$1, AtomicInteger counter$1, InputMethod inputMethod) {
        ExitCode code = MODULE$.handleFile(inputMethod, options$1, scalafmtConf$1);
        exitCode$1.getAndUpdate(x$1 -> ExitCode$.MODULE$.merge(code, (ExitCode)x$1));
        if (options$1.check() && !code.isOk()) {
            throw Breaks$.MODULE$.break();
        }
        PlatformTokenizerCache$.MODULE$.megaCache().clear();
        termDisplay$1.taskProgress(termDisplayMessage$1, counter$1.incrementAndGet());
    }

    private ScalafmtCoreRunner$() {
    }
}

