/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.scalafmt.Error;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.FailedToFormat;
import org.scalafmt.dynamic.exceptions.ScalafmtException;
import org.scalafmt.interfaces.PositionException;
import org.scalafmt.interfaces.ScalafmtReporter;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005}4A\u0001D\u0007\u0001)!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rm\u0002\u0001\u0015!\u0003/\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015q\u0004\u0001\"\u0011@\u0011\u0015q\u0004\u0001\"\u0011]\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015Q\b\u0001\"\u0011|\u0005M\u00196-\u00197bM6$8\t\\5SKB|'\u000f^3s\u0015\tqq\"A\u0002dY&T!\u0001E\t\u0002\u0011M\u001c\u0017\r\\1g[RT\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001Ui\u0002C\u0001\f\u001c\u001b\u00059\"B\u0001\r\u001a\u0003\u0011a\u0017M\\4\u000b\u0003i\tAA[1wC&\u0011Ad\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001z\u0011AC5oi\u0016\u0014h-Y2fg&\u0011!e\b\u0002\u0011'\u000e\fG.\u00194niJ+\u0007o\u001c:uKJ\fqa\u001c9uS>t7\u000f\u0005\u0002&M5\tQ\"\u0003\u0002(\u001b\tQ1\t\\5PaRLwN\\:\u0002\rqJg.\u001b;?)\tQ3\u0006\u0005\u0002&\u0001!)1E\u0001a\u0001I\u0005AQ\r_5u\u0007>$W-F\u0001/!\ryc\u0007O\u0007\u0002a)\u0011\u0011GM\u0001\u0007CR|W.[2\u000b\u0005M\"\u0014AC2p]\u000e,(O]3oi*\u0011Q'G\u0001\u0005kRLG.\u0003\u00028a\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002&s%\u0011!(\u0004\u0002\t\u000bbLGoQ8eK\u0006IQ\r_5u\u0007>$W\rI\u0001\fO\u0016$X\t_5u\u0007>$W-F\u00019\u0003\u0015)'O]8s)\r\u0001ei\u0014\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0005+:LG\u000fC\u0003H\r\u0001\u0007\u0001*\u0001\u0003gS2,\u0007CA%N\u001b\u0005Q%BA$L\u0015\ta\u0015$A\u0002oS>L!A\u0014&\u0003\tA\u000bG\u000f\u001b\u0005\u0006!\u001a\u0001\r!U\u0001\b[\u0016\u001c8/Y4f!\t\u0011\u0016L\u0004\u0002T/B\u0011AKQ\u0007\u0002+*\u0011akE\u0001\u0007yI|w\u000e\u001e \n\u0005a\u0013\u0015A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001\u0017\"\u0015\u0007\u0001kf\fC\u0003H\u000f\u0001\u0007\u0001\nC\u0003`\u000f\u0001\u0007\u0001-A\u0001f!\t\tgM\u0004\u0002cI:\u0011AkY\u0005\u0002\u0007&\u0011QMQ\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007NA\u0005UQJ|w/\u00192mK*\u0011QMQ\u0001\tKb\u001cG.\u001e3fIR\u0011\u0001i\u001b\u0005\u0006\u000f\"\u0001\r\u0001S\u0001\ra\u0006\u00148/\u001a3D_:4\u0017n\u001a\u000b\u0004\u0001:\u0004\b\"B8\n\u0001\u0004A\u0015AB2p]\u001aLw\rC\u0003r\u0013\u0001\u0007\u0011+A\btG\u0006d\u0017MZ7u-\u0016\u00148/[8o\u00039!wn\u001e8m_\u0006$wK]5uKJ$\u0012\u0001\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003of\t!![8\n\u0005e4(a\u0003)sS:$xK]5uKJ\f!\u0004Z8x]2|\u0017\rZ(viB,Ho\u0015;sK\u0006lwK]5uKJ$\u0012\u0001 \t\u0003kvL!A <\u0003%=+H\u000f];u'R\u0014X-Y7Xe&$XM\u001d")
public class ScalafmtCliReporter
implements ScalafmtReporter {
    private final CliOptions options;
    private final AtomicReference<ExitCode> exitCode;

    public void error(Path x$1, String x$2, Throwable x$3) {
        super.error(x$1, x$2, x$3);
    }

    public void missingVersion(Path x$1, String x$2) {
        super.missingVersion(x$1, x$2);
    }

    private AtomicReference<ExitCode> exitCode() {
        return this.exitCode;
    }

    public ExitCode getExitCode() {
        return this.exitCode().get();
    }

    public void error(Path file, String message) {
        block0: {
            if (this.options.ignoreWarnings()) break block0;
            this.options.common().err().println(new StringBuilder(2).append(message).append(": ").append(file).toString());
            this.exitCode().getAndUpdate(x$1 -> ExitCode$.MODULE$.merge(ExitCode$.MODULE$.UnexpectedError(), (ExitCode)x$1));
        }
    }

    public void error(Path file, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof PositionException && !this.options.ignoreWarnings()) {
            this.options.common().err().println(new StringBuilder(2).append(e.toString()).append(": ").append(file).toString());
            this.exitCode().getAndUpdate(x$2 -> ExitCode$.MODULE$.merge(ExitCode$.MODULE$.ParseError(), (ExitCode)x$2));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof Error.MisformattedFile) {
            Error.MisformattedFile misformattedFile = (Error.MisformattedFile)throwable;
            String diff = misformattedFile.customMessage();
            this.options.common().err().println(diff);
            this.exitCode().getAndUpdate(x$3 -> ExitCode$.MODULE$.merge(ExitCode$.MODULE$.TestError(), (ExitCode)x$3));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof ScalafmtException) {
            ScalafmtException scalafmtException = (ScalafmtException)throwable;
            Throwable cause = scalafmtException.cause();
            this.error(file, cause);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (!this.options.ignoreWarnings()) {
            new FailedToFormat(((Object)file).toString(), e).printStackTrace(this.options.common().err());
            this.exitCode().getAndUpdate(x$4 -> ExitCode$.MODULE$.merge(ExitCode$.MODULE$.UnexpectedError(), (ExitCode)x$4));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)throwable);
        }
    }

    public void excluded(Path file) {
        this.options.common().debug().println(new StringBuilder(15).append("file excluded: ").append(file).toString());
    }

    public void parsedConfig(Path config, String scalafmtVersion) {
        this.options.common().debug().println(new StringBuilder(19).append("parsed config (v").append(scalafmtVersion).append("): ").append(config).toString());
    }

    public PrintWriter downloadWriter() {
        return new PrintWriter(this.options.common().out());
    }

    public OutputStreamWriter downloadOutputStreamWriter() {
        return new OutputStreamWriter(this.options.common().out());
    }

    public ScalafmtCliReporter(CliOptions options) {
        this.options = options;
        this.exitCode = new AtomicReference<ExitCode>(ExitCode$.MODULE$.Ok());
    }
}

