/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import org.scalafmt.Versions$;
import org.scalafmt.cli.CliArgParser;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.DiffFiles;
import org.scalafmt.cli.FileFetchMode;
import org.scalafmt.cli.FileFetchMode$;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.cli.WriteMode$List$;
import org.scalafmt.cli.WriteMode$Override$;
import org.scalafmt.cli.WriteMode$Stdout$;
import org.scalafmt.cli.WriteMode$Test$;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.GitOps;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scopt.OptionParser;
import scopt.Read$;

public final class CliArgParser$ {
    public static final CliArgParser$ MODULE$ = new CliArgParser$();
    private static final String usageExamples = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|scalafmt # Format all files in the current project, configuration is determined in this order:\n      |         # 1. .scalafmt.conf file in current directory\n      |         # 2. .scalafmt.conf inside root directory of current git repo\n      |         # 3. no configuration, default style\n      |scalafmt --test # throw exception on mis-formatted files, won't write to files.\n      |scalafmt --mode diff # Format all files that were edited in git diff against master branch.\n      |scalafmt --mode changed # Format files listed in `git status` (latest changes against previous commit.\n      |scalafmt --diff-branch 2.x # same as --diff, except against branch 2.x\n      |scalafmt --stdin # read from stdin and print to stdout\n      |scalafmt --stdin --assume-filename foo.sbt < foo.sbt # required when using --stdin to format .sbt files.\n      |scalafmt Code1.scala A.scala       # write formatted contents to file.\n      |scalafmt --stdout Code.scala       # print formatted contents to stdout.\n      |scalafmt --exclude target          # format all files in directory excluding target\n      |scalafmt --config .scalafmt.conf   # read custom style from file.\n      |scalafmt --config-str \"style=IntelliJ\" # define custom style as a flag, must be quoted."));
    private static final OptionParser<CliOptions> scoptParser = new OptionParser<CliOptions>(){

        public Option<Object> showUsageOnError() {
            return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }

        private CliOptions printAndExit(boolean includeUsage, BoxedUnit ignore, CliOptions c) {
            if (includeUsage) {
                this.displayToOut(this.usage());
            } else {
                this.displayToOut(this.header());
            }
            throw scala.sys.package$.MODULE$.exit();
        }

        private CliOptions readConfig(String contents, CliOptions c) {
            Some x$1 = new Some((Object)contents);
            Option<File> x$2 = c.copy$default$1();
            Set<Range> x$3 = c.copy$default$3();
            Seq<File> x$4 = c.copy$default$4();
            Seq<String> x$5 = c.copy$default$5();
            boolean x$6 = c.copy$default$6();
            boolean x$7 = c.copy$default$7();
            Option<FileFetchMode> x$8 = c.copy$default$8();
            String x$9 = c.copy$default$9();
            CommonOptions x$10 = c.copy$default$10();
            Function1<AbsoluteFile, GitOps> x$11 = c.copy$default$11();
            Option<WriteMode> x$12 = c.copy$default$12();
            boolean x$13 = c.copy$default$13();
            boolean x$14 = c.copy$default$14();
            boolean x$15 = c.copy$default$15();
            boolean x$16 = c.copy$default$16();
            boolean x$17 = c.copy$default$17();
            boolean x$18 = c.copy$default$18();
            return c.copy(x$2, (Option<String>)x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
        }
        {
            this.head((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scalafmt", Versions$.MODULE$.nightly()}));
            this.opt('h', "help", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(ignore, c) -> this.printAndExit(true, (BoxedUnit)ignore, (CliOptions)c)).text("prints this usage text");
            this.opt('v', "version", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(ignore, c) -> this.printAndExit(false, (BoxedUnit)ignore, (CliOptions)c)).text("print version ");
            this.arg("<file>...", Read$.MODULE$.fileRead()).optional().unbounded().action((Function2 & Serializable)(file, c) -> c.addFile((File)file)).text(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("file, or directory (in which all *.scala files are to be formatted);\n            |if starts with '@', refers to path listing files to be formatted\n            |(with \"@-\" referring to standard input as a special case)")));
            this.opt('f', "files", Read$.MODULE$.immutableSeqRead(Read$.MODULE$.fileRead())).action((Function2 & Serializable)(files, c) -> c.withFiles((Seq<File>)files)).hidden().text("file or directory, in which case all *.scala files are formatted. Deprecated: pass files as arguments");
            this.opt('i', "in-place", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$1, c) -> CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$Override$.MODULE$)).hidden().text("format files in-place (default)");
            this.opt("stdout", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$2, c) -> CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$Stdout$.MODULE$)).text("write formatted files to stdout");
            this.opt("exclude", Read$.MODULE$.immutableSeqRead(Read$.MODULE$.stringRead())).unbounded().action((Function2 & Serializable)(excludes, c) -> {
                Seq x$1 = excludes;
                Option<File> x$2 = c.copy$default$1();
                Option<String> x$3 = c.copy$default$2();
                Set<Range> x$4 = c.copy$default$3();
                Seq<File> x$5 = c.copy$default$4();
                boolean x$6 = c.copy$default$6();
                boolean x$7 = c.copy$default$7();
                Option<FileFetchMode> x$8 = c.copy$default$8();
                String x$9 = c.copy$default$9();
                CommonOptions x$10 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$11 = c.copy$default$11();
                Option<WriteMode> x$12 = c.copy$default$12();
                boolean x$13 = c.copy$default$13();
                boolean x$14 = c.copy$default$14();
                boolean x$15 = c.copy$default$15();
                boolean x$16 = c.copy$default$16();
                boolean x$17 = c.copy$default$17();
                boolean x$18 = c.copy$default$18();
                return c.copy(x$2, x$3, x$4, x$5, (Seq<String>)x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
            }).text("file or directory, when missing all *.scala files are formatted.");
            this.opt("respect-project-filters", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$3, c) -> {
                boolean x$19 = true;
                Option<File> x$20 = c.copy$default$1();
                Option<String> x$21 = c.copy$default$2();
                Set<Range> x$22 = c.copy$default$3();
                Seq<File> x$23 = c.copy$default$4();
                Seq<String> x$24 = c.copy$default$5();
                boolean x$25 = c.copy$default$7();
                Option<FileFetchMode> x$26 = c.copy$default$8();
                String x$27 = c.copy$default$9();
                CommonOptions x$28 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$29 = c.copy$default$11();
                Option<WriteMode> x$30 = c.copy$default$12();
                boolean x$31 = c.copy$default$13();
                boolean x$32 = c.copy$default$14();
                boolean x$33 = c.copy$default$15();
                boolean x$34 = c.copy$default$16();
                boolean x$35 = c.copy$default$17();
                boolean x$36 = c.copy$default$18();
                return c.copy(x$20, x$21, x$22, x$23, x$24, true, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36);
            }).text("use project filters even when specific files to format are provided");
            this.opt('c', "config", Read$.MODULE$.fileRead()).action((Function2 & Serializable)(file, c) -> c.copy((Option<File>)new Some(file), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15(), c.copy$default$16(), c.copy$default$17(), c.copy$default$18())).text("a file path to .scalafmt.conf.");
            this.opt("config-str", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(contents, c) -> this.readConfig((String)contents, (CliOptions)c)).text("configuration defined as a string");
            this.opt("stdin", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$4, c) -> {
                boolean x$37 = true;
                Option<File> x$38 = c.copy$default$1();
                Option<String> x$39 = c.copy$default$2();
                Set<Range> x$40 = c.copy$default$3();
                Seq<File> x$41 = c.copy$default$4();
                Seq<String> x$42 = c.copy$default$5();
                boolean x$43 = c.copy$default$6();
                boolean x$44 = c.copy$default$7();
                Option<FileFetchMode> x$45 = c.copy$default$8();
                String x$46 = c.copy$default$9();
                CommonOptions x$47 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$48 = c.copy$default$11();
                Option<WriteMode> x$49 = c.copy$default$12();
                boolean x$50 = c.copy$default$13();
                boolean x$51 = c.copy$default$14();
                boolean x$52 = c.copy$default$16();
                boolean x$53 = c.copy$default$17();
                boolean x$54 = c.copy$default$18();
                return c.copy(x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, true, x$52, x$53, x$54);
            }).text("read from stdin and print to stdout");
            this.opt("no-stderr", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$5, c) -> {
                boolean x$55 = true;
                Option<File> x$56 = c.copy$default$1();
                Option<String> x$57 = c.copy$default$2();
                Set<Range> x$58 = c.copy$default$3();
                Seq<File> x$59 = c.copy$default$4();
                Seq<String> x$60 = c.copy$default$5();
                boolean x$61 = c.copy$default$6();
                boolean x$62 = c.copy$default$7();
                Option<FileFetchMode> x$63 = c.copy$default$8();
                String x$64 = c.copy$default$9();
                CommonOptions x$65 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$66 = c.copy$default$11();
                Option<WriteMode> x$67 = c.copy$default$12();
                boolean x$68 = c.copy$default$13();
                boolean x$69 = c.copy$default$14();
                boolean x$70 = c.copy$default$15();
                boolean x$71 = c.copy$default$17();
                boolean x$72 = c.copy$default$18();
                return c.copy(x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$69, x$70, true, x$71, x$72);
            }).text("don't use strerr for messages, output to stdout");
            this.opt("assume-filename", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(filename, c) -> {
                String x$73 = filename;
                Option<File> x$74 = c.copy$default$1();
                Option<String> x$75 = c.copy$default$2();
                Set<Range> x$76 = c.copy$default$3();
                Seq<File> x$77 = c.copy$default$4();
                Seq<String> x$78 = c.copy$default$5();
                boolean x$79 = c.copy$default$6();
                boolean x$80 = c.copy$default$7();
                Option<FileFetchMode> x$81 = c.copy$default$8();
                CommonOptions x$82 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$83 = c.copy$default$11();
                Option<WriteMode> x$84 = c.copy$default$12();
                boolean x$85 = c.copy$default$13();
                boolean x$86 = c.copy$default$14();
                boolean x$87 = c.copy$default$15();
                boolean x$88 = c.copy$default$16();
                boolean x$89 = c.copy$default$17();
                boolean x$90 = c.copy$default$18();
                return c.copy(x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$73, x$82, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90);
            }).text("when using --stdin, use --assume-filename to hint to scalafmt that the input is an .sbt file.");
            this.opt("reportError", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$6, c) -> {
                boolean x$91 = true;
                Option<File> x$92 = c.copy$default$1();
                Option<String> x$93 = c.copy$default$2();
                Set<Range> x$94 = c.copy$default$3();
                Seq<File> x$95 = c.copy$default$4();
                Seq<String> x$96 = c.copy$default$5();
                boolean x$97 = c.copy$default$6();
                boolean x$98 = c.copy$default$7();
                Option<FileFetchMode> x$99 = c.copy$default$8();
                String x$100 = c.copy$default$9();
                CommonOptions x$101 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$102 = c.copy$default$11();
                Option<WriteMode> x$103 = c.copy$default$12();
                boolean x$104 = c.copy$default$13();
                boolean x$105 = c.copy$default$14();
                boolean x$106 = c.copy$default$15();
                boolean x$107 = c.copy$default$16();
                boolean x$108 = c.copy$default$18();
                return c.copy(x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102, x$103, x$104, x$105, x$106, x$107, true, x$108);
            }).text("exit with status 1 if any mis-formatted code found.");
            this.opt("test", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$7, c) -> {
                CliOptions qual$1 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$Test$.MODULE$);
                boolean x$109 = true;
                Option<File> x$110 = qual$1.copy$default$1();
                Option<String> x$111 = qual$1.copy$default$2();
                Set<Range> x$112 = qual$1.copy$default$3();
                Seq<File> x$113 = qual$1.copy$default$4();
                Seq<String> x$114 = qual$1.copy$default$5();
                boolean x$115 = qual$1.copy$default$6();
                boolean x$116 = qual$1.copy$default$7();
                Option<FileFetchMode> x$117 = qual$1.copy$default$8();
                String x$118 = qual$1.copy$default$9();
                CommonOptions x$119 = qual$1.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$120 = qual$1.copy$default$11();
                Option<WriteMode> x$121 = qual$1.copy$default$12();
                boolean x$122 = qual$1.copy$default$13();
                boolean x$123 = qual$1.copy$default$14();
                boolean x$124 = qual$1.copy$default$15();
                boolean x$125 = qual$1.copy$default$16();
                boolean x$126 = qual$1.copy$default$18();
                return qual$1.copy(x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119, x$120, x$121, x$122, x$123, x$124, x$125, true, x$126);
            }).text("test for mis-formatted code only, exits with status 1 on failure.");
            this.opt("check", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$8, c) -> {
                CliOptions qual$2 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$Test$.MODULE$);
                boolean x$127 = true;
                boolean x$128 = true;
                Option<File> x$129 = qual$2.copy$default$1();
                Option<String> x$130 = qual$2.copy$default$2();
                Set<Range> x$131 = qual$2.copy$default$3();
                Seq<File> x$132 = qual$2.copy$default$4();
                Seq<String> x$133 = qual$2.copy$default$5();
                boolean x$134 = qual$2.copy$default$6();
                boolean x$135 = qual$2.copy$default$7();
                Option<FileFetchMode> x$136 = qual$2.copy$default$8();
                String x$137 = qual$2.copy$default$9();
                CommonOptions x$138 = qual$2.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$139 = qual$2.copy$default$11();
                Option<WriteMode> x$140 = qual$2.copy$default$12();
                boolean x$141 = qual$2.copy$default$13();
                boolean x$142 = qual$2.copy$default$14();
                boolean x$143 = qual$2.copy$default$15();
                boolean x$144 = qual$2.copy$default$16();
                return qual$2.copy(x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136, x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, true, true);
            }).text("test for mis-formatted code only, exits with status 1 on first failure.");
            this.opt("diff", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$9, c) -> {
                Option x$145 = Option$.MODULE$.apply((Object)new DiffFiles("master"));
                Option<File> x$146 = c.copy$default$1();
                Option<String> x$147 = c.copy$default$2();
                Set<Range> x$148 = c.copy$default$3();
                Seq<File> x$149 = c.copy$default$4();
                Seq<String> x$150 = c.copy$default$5();
                boolean x$151 = c.copy$default$6();
                boolean x$152 = c.copy$default$7();
                String x$153 = c.copy$default$9();
                CommonOptions x$154 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$155 = c.copy$default$11();
                Option<WriteMode> x$156 = c.copy$default$12();
                boolean x$157 = c.copy$default$13();
                boolean x$158 = c.copy$default$14();
                boolean x$159 = c.copy$default$15();
                boolean x$160 = c.copy$default$16();
                boolean x$161 = c.copy$default$17();
                boolean x$162 = c.copy$default$18();
                return c.copy(x$146, x$147, x$148, x$149, x$150, x$151, x$152, (Option<FileFetchMode>)x$145, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162);
            }).text(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Format files listed in `git diff` against master.\n            |Deprecated: use --mode diff instead")));
            this.opt("mode", FileFetchMode$.MODULE$.read()).action((Function2 & Serializable)(m, c) -> {
                Option x$163 = Option$.MODULE$.apply(m);
                Option<File> x$164 = c.copy$default$1();
                Option<String> x$165 = c.copy$default$2();
                Set<Range> x$166 = c.copy$default$3();
                Seq<File> x$167 = c.copy$default$4();
                Seq<String> x$168 = c.copy$default$5();
                boolean x$169 = c.copy$default$6();
                boolean x$170 = c.copy$default$7();
                String x$171 = c.copy$default$9();
                CommonOptions x$172 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$173 = c.copy$default$11();
                Option<WriteMode> x$174 = c.copy$default$12();
                boolean x$175 = c.copy$default$13();
                boolean x$176 = c.copy$default$14();
                boolean x$177 = c.copy$default$15();
                boolean x$178 = c.copy$default$16();
                boolean x$179 = c.copy$default$17();
                boolean x$180 = c.copy$default$18();
                return c.copy(x$164, x$165, x$166, x$167, x$168, x$169, x$170, (Option<FileFetchMode>)x$163, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180);
            }).text(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Sets the files to be formatted fetching mode.\n            |Options:\n            |        diff - format files listed in `git diff` against master\n            |        changed - format files listed in `git status` (latest changes against previous commit)")));
            this.opt("diff-branch", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(branch, c) -> {
                Option x$181 = Option$.MODULE$.apply((Object)new DiffFiles((String)branch));
                Option<File> x$182 = c.copy$default$1();
                Option<String> x$183 = c.copy$default$2();
                Set<Range> x$184 = c.copy$default$3();
                Seq<File> x$185 = c.copy$default$4();
                Seq<String> x$186 = c.copy$default$5();
                boolean x$187 = c.copy$default$6();
                boolean x$188 = c.copy$default$7();
                String x$189 = c.copy$default$9();
                CommonOptions x$190 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$191 = c.copy$default$11();
                Option<WriteMode> x$192 = c.copy$default$12();
                boolean x$193 = c.copy$default$13();
                boolean x$194 = c.copy$default$14();
                boolean x$195 = c.copy$default$15();
                boolean x$196 = c.copy$default$16();
                boolean x$197 = c.copy$default$17();
                boolean x$198 = c.copy$default$18();
                return c.copy(x$182, x$183, x$184, x$185, x$186, x$187, x$188, (Option<FileFetchMode>)x$181, x$189, x$190, x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$198);
            }).text("If set, only format edited files in git diff against provided branch. Has no effect if mode set to `changed`.");
            this.opt("build-info", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$10, x$11) -> {
                Predef$.MODULE$.println((Object)CliArgParser$.MODULE$.buildInfo());
                return scala.sys.package$.MODULE$.exit();
            }).text("prints build information");
            this.opt("quiet", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$12, c) -> {
                boolean x$199 = true;
                Option<File> x$200 = c.copy$default$1();
                Option<String> x$201 = c.copy$default$2();
                Set<Range> x$202 = c.copy$default$3();
                Seq<File> x$203 = c.copy$default$4();
                Seq<String> x$204 = c.copy$default$5();
                boolean x$205 = c.copy$default$6();
                boolean x$206 = c.copy$default$7();
                Option<FileFetchMode> x$207 = c.copy$default$8();
                String x$208 = c.copy$default$9();
                CommonOptions x$209 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$210 = c.copy$default$11();
                Option<WriteMode> x$211 = c.copy$default$12();
                boolean x$212 = c.copy$default$13();
                boolean x$213 = c.copy$default$15();
                boolean x$214 = c.copy$default$16();
                boolean x$215 = c.copy$default$17();
                boolean x$216 = c.copy$default$18();
                return c.copy(x$200, x$201, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210, x$211, x$212, true, x$213, x$214, x$215, x$216);
            }).text("don't print out stuff to console.");
            this.opt("debug", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$13, c) -> {
                boolean x$217 = true;
                Option<File> x$218 = c.copy$default$1();
                Option<String> x$219 = c.copy$default$2();
                Set<Range> x$220 = c.copy$default$3();
                Seq<File> x$221 = c.copy$default$4();
                Seq<String> x$222 = c.copy$default$5();
                boolean x$223 = c.copy$default$6();
                boolean x$224 = c.copy$default$7();
                Option<FileFetchMode> x$225 = c.copy$default$8();
                String x$226 = c.copy$default$9();
                CommonOptions x$227 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$228 = c.copy$default$11();
                Option<WriteMode> x$229 = c.copy$default$12();
                boolean x$230 = c.copy$default$14();
                boolean x$231 = c.copy$default$15();
                boolean x$232 = c.copy$default$16();
                boolean x$233 = c.copy$default$17();
                boolean x$234 = c.copy$default$18();
                return c.copy(x$218, x$219, x$220, x$221, x$222, x$223, x$224, x$225, x$226, x$227, x$228, x$229, true, x$230, x$231, x$232, x$233, x$234);
            }).text("print out diagnostics to console.");
            this.opt("non-interactive", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$14, c) -> {
                boolean x$235 = true;
                Option<File> x$236 = c.copy$default$1();
                Option<String> x$237 = c.copy$default$2();
                Set<Range> x$238 = c.copy$default$3();
                Seq<File> x$239 = c.copy$default$4();
                Seq<String> x$240 = c.copy$default$5();
                boolean x$241 = c.copy$default$6();
                Option<FileFetchMode> x$242 = c.copy$default$8();
                String x$243 = c.copy$default$9();
                CommonOptions x$244 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$245 = c.copy$default$11();
                Option<WriteMode> x$246 = c.copy$default$12();
                boolean x$247 = c.copy$default$13();
                boolean x$248 = c.copy$default$14();
                boolean x$249 = c.copy$default$15();
                boolean x$250 = c.copy$default$16();
                boolean x$251 = c.copy$default$17();
                boolean x$252 = c.copy$default$18();
                return c.copy(x$236, x$237, x$238, x$239, x$240, x$241, true, x$242, x$243, x$244, x$245, x$246, x$247, x$248, x$249, x$250, x$251, x$252);
            }).text("disable fancy progress bar, useful in ci or sbt plugin.");
            this.opt("list", Read$.MODULE$.unitRead()).action((Function2 & Serializable)(x$15, c) -> {
                CliOptions qual$3 = CliArgParser$.MODULE$.org$scalafmt$cli$CliArgParser$$writeMode((CliOptions)c, WriteMode$List$.MODULE$);
                boolean x$253 = true;
                Option<File> x$254 = qual$3.copy$default$1();
                Option<String> x$255 = qual$3.copy$default$2();
                Set<Range> x$256 = qual$3.copy$default$3();
                Seq<File> x$257 = qual$3.copy$default$4();
                Seq<String> x$258 = qual$3.copy$default$5();
                boolean x$259 = qual$3.copy$default$6();
                boolean x$260 = qual$3.copy$default$7();
                Option<FileFetchMode> x$261 = qual$3.copy$default$8();
                String x$262 = qual$3.copy$default$9();
                CommonOptions x$263 = qual$3.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$264 = qual$3.copy$default$11();
                Option<WriteMode> x$265 = qual$3.copy$default$12();
                boolean x$266 = qual$3.copy$default$13();
                boolean x$267 = qual$3.copy$default$14();
                boolean x$268 = qual$3.copy$default$15();
                boolean x$269 = qual$3.copy$default$16();
                boolean x$270 = qual$3.copy$default$18();
                return qual$3.copy(x$254, x$255, x$256, x$257, x$258, x$259, x$260, x$261, x$262, x$263, x$264, x$265, x$266, x$267, x$268, x$269, true, x$270);
            }).text("list files that are different from scalafmt formatting");
            this.opt("range", Read$.MODULE$.tupleRead(Read$.MODULE$.intRead(), Read$.MODULE$.intRead())).hidden().action((Function2 & Serializable)(x0$1, x1$1) -> {
                int to;
                CliOptions c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (CliOptions)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                int from = tuple2._1$mcI$sp();
                int offset = from == (to = tuple2._2$mcI$sp()) ? 0 : -1;
                Set x$271 = (Set)c.range().$plus((Object)package$.MODULE$.Range().apply(from - 1, to + offset));
                Option<File> x$272 = c.copy$default$1();
                Option<String> x$273 = c.copy$default$2();
                Seq<File> x$274 = c.copy$default$4();
                Seq<String> x$275 = c.copy$default$5();
                boolean x$276 = c.copy$default$6();
                boolean x$277 = c.copy$default$7();
                Option<FileFetchMode> x$278 = c.copy$default$8();
                String x$279 = c.copy$default$9();
                CommonOptions x$280 = c.copy$default$10();
                Function1<AbsoluteFile, GitOps> x$281 = c.copy$default$11();
                Option<WriteMode> x$282 = c.copy$default$12();
                boolean x$283 = c.copy$default$13();
                boolean x$284 = c.copy$default$14();
                boolean x$285 = c.copy$default$15();
                boolean x$286 = c.copy$default$16();
                boolean x$287 = c.copy$default$17();
                boolean x$288 = c.copy$default$18();
                CliOptions cliOptions = c.copy(x$272, x$273, (Set<Range>)x$271, x$274, x$275, x$276, x$277, x$278, x$279, x$280, x$281, x$282, x$283, x$284, x$285, x$286, x$287, x$288);
                return cliOptions;
            }).text("(experimental) only format line range from=to");
            this.note(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(101).append("|Examples:\n        |").append(CliArgParser$.MODULE$.usageExamples()).append("\n        |Please file bugs to https://github.com/scalameta/scalafmt/issues\n      ").toString())));
            this.checkConfig((Function1 & Serializable)c -> c.config().isDefined() && c.configStr().isDefined() ? this.failure("may not specify both --config and --config-str") : this.success());
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(org.scalafmt.cli.CliArgParser$$anon$1 scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$10(org.scalafmt.cli.CliArgParser$$anon$1 java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$11(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$12(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$13(java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$14(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$15(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$16(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$17(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$18(org.scalafmt.cli.FileFetchMode org.scalafmt.cli.CliOptions ), $anonfun$new$19(java.lang.String org.scalafmt.cli.CliOptions ), $anonfun$new$2(org.scalafmt.cli.CliArgParser$$anon$1 scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$20(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$21(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$22(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$23(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$24(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$25(scala.Tuple2 org.scalafmt.cli.CliOptions ), $anonfun$new$26(org.scalafmt.cli.CliArgParser$$anon$1 org.scalafmt.cli.CliOptions ), $anonfun$new$3(java.io.File org.scalafmt.cli.CliOptions ), $anonfun$new$4(scala.collection.immutable.Seq org.scalafmt.cli.CliOptions ), $anonfun$new$5(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$6(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$7(scala.collection.immutable.Seq org.scalafmt.cli.CliOptions ), $anonfun$new$8(scala.runtime.BoxedUnit org.scalafmt.cli.CliOptions ), $anonfun$new$9(java.io.File org.scalafmt.cli.CliOptions )}, serializedLambda);
        }
    };

    public String usageExamples() {
        return usageExamples;
    }

    public OptionParser<CliOptions> scoptParser() {
        return scoptParser;
    }

    public String buildInfo() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(34).append("build commit: ").append(Versions$.MODULE$.commit()).append("\n      |build time: ").append(new Date(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(Versions$.MODULE$.timestamp())))).toString()));
    }

    public CliOptions org$scalafmt$cli$CliArgParser$$writeMode(CliOptions c, WriteMode writeMode) {
        return (CliOptions)c.writeModeOpt().fold((Function0 & Serializable)() -> {
            Some x$1 = new Some((Object)writeMode);
            Option<File> x$2 = c.copy$default$1();
            Option<String> x$3 = c.copy$default$2();
            Set<Range> x$4 = c.copy$default$3();
            Seq<File> x$5 = c.copy$default$4();
            Seq<String> x$6 = c.copy$default$5();
            boolean x$7 = c.copy$default$6();
            boolean x$8 = c.copy$default$7();
            Option<FileFetchMode> x$9 = c.copy$default$8();
            String x$10 = c.copy$default$9();
            CommonOptions x$11 = c.copy$default$10();
            Function1<AbsoluteFile, GitOps> x$12 = c.copy$default$11();
            boolean x$13 = c.copy$default$13();
            boolean x$14 = c.copy$default$14();
            boolean x$15 = c.copy$default$15();
            boolean x$16 = c.copy$default$16();
            boolean x$17 = c.copy$default$17();
            boolean x$18 = c.copy$default$18();
            return c.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Option<WriteMode>)x$1, x$13, x$14, x$15, x$16, x$17, x$18);
        }, (Function1 & Serializable)x -> {
            WriteMode writeMode = x;
            WriteMode writeMode2 = writeMode;
            if (writeMode == null ? writeMode2 != null : !writeMode.equals(writeMode2)) {
                throw new CliArgParser.Conflict(new StringBuilder(28).append("writeMode changing from ").append(x).append(" to ").append(writeMode).toString());
            }
            return c;
        });
    }

    private CliArgParser$() {
    }
}

