/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import com.martiansoftware.nailgun.NGContext;
import java.io.File;
import java.io.Serializable;
import org.scalafmt.Versions$;
import org.scalafmt.cli.Cli$FileArgument$;
import org.scalafmt.cli.CliArgParser$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CliOptions$;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.FileFetchMode;
import org.scalafmt.cli.ScalafmtCoreRunner$;
import org.scalafmt.cli.ScalafmtDynamicRunner$;
import org.scalafmt.cli.ScalafmtRunner;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.cli.WriteMode$Test$;
import org.scalafmt.util.AbsoluteFile;
import org.scalafmt.util.AbsoluteFile$;
import org.scalafmt.util.GitOps;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NoStackTrace;

public final class Cli$ {
    public static final Cli$ MODULE$ = new Cli$();
    private static final boolean isNativeImage = "true".equals(System.getProperty("scalafmt.native-image", "false"));

    public void nailMain(NGContext nGContext) {
        AbsoluteFile workingDirectory = (AbsoluteFile)AbsoluteFile$.MODULE$.fromPath(nGContext.getWorkingDirectory()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(0).append("Expected absolute path, ").append(new StringBuilder(41).append("obtained nGContext.getWorkingDirectory = ").append(nGContext.getWorkingDirectory()).toString()).toString());
        });
        CommonOptions x$1 = CliOptions$.MODULE$.default().common().copy(workingDirectory, nGContext.out, nGContext.in, nGContext.err, CliOptions$.MODULE$.default().common().copy$default$5(), CliOptions$.MODULE$.default().common().copy$default$6());
        Option<File> x$2 = CliOptions$.MODULE$.default().copy$default$1();
        Option<String> x$3 = CliOptions$.MODULE$.default().copy$default$2();
        Set<Range> x$4 = CliOptions$.MODULE$.default().copy$default$3();
        scala.collection.immutable.Seq<File> x$5 = CliOptions$.MODULE$.default().copy$default$4();
        scala.collection.immutable.Seq<String> x$6 = CliOptions$.MODULE$.default().copy$default$5();
        boolean x$7 = CliOptions$.MODULE$.default().copy$default$6();
        boolean x$8 = CliOptions$.MODULE$.default().copy$default$7();
        Option<FileFetchMode> x$9 = CliOptions$.MODULE$.default().copy$default$8();
        String x$10 = CliOptions$.MODULE$.default().copy$default$9();
        Function1<AbsoluteFile, GitOps> x$11 = CliOptions$.MODULE$.default().copy$default$11();
        Option<WriteMode> x$12 = CliOptions$.MODULE$.default().copy$default$12();
        boolean x$13 = CliOptions$.MODULE$.default().copy$default$13();
        boolean x$14 = CliOptions$.MODULE$.default().copy$default$14();
        boolean x$15 = CliOptions$.MODULE$.default().copy$default$15();
        boolean x$16 = CliOptions$.MODULE$.default().copy$default$16();
        boolean x$17 = CliOptions$.MODULE$.default().copy$default$17();
        boolean x$18 = CliOptions$.MODULE$.default().copy$default$18();
        ExitCode exit = this.mainWithOptions(nGContext.getArgs(), CliOptions$.MODULE$.default().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18));
        nGContext.exit(exit.code());
    }

    private void throwIfError(ExitCode exit) {
        ExitCode exitCode = exit;
        ExitCode exitCode2 = ExitCode$.MODULE$.Ok();
        if (exitCode == null ? exitCode2 != null : !((Object)exitCode).equals(exitCode2)) {
            throw new NoStackTrace(exit){

                public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                    return super.fillInStackTrace();
                }

                public Throwable fillInStackTrace() {
                    return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
                }
                {
                    NoStackTrace.$init$((NoStackTrace)this);
                }
            };
        }
    }

    public void main(String[] args) {
        ExitCode exit = this.mainWithOptions(args, CliOptions$.MODULE$.default());
        throw scala.sys.package$.MODULE$.exit(exit.code());
    }

    public void exceptionThrowingMain(String[] args) {
        ExitCode exit = this.mainWithOptions(args, CliOptions$.MODULE$.default());
        this.throwIfError(exit);
    }

    public ExitCode mainWithOptions(String[] args, CliOptions options) {
        ExitCode exitCode;
        Option<CliOptions> option = this.getConfig(args, options);
        if (option instanceof Some) {
            Some some = (Some)option;
            CliOptions x = (CliOptions)some.value();
            exitCode = this.run(x);
        } else if (None$.MODULE$.equals(option)) {
            exitCode = ExitCode$.MODULE$.CommandLineArgumentError();
        } else {
            throw new MatchError(option);
        }
        return exitCode;
    }

    public Option<CliOptions> getConfig(String[] args, CliOptions init) {
        String[] expandedArguments = this.expandArguments(args);
        return CliArgParser$.MODULE$.scoptParser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])expandedArguments), (Object)init).map((Function1 & Serializable)parsed -> CliOptions$.MODULE$.auto((CliOptions)parsed));
    }

    private String[] expandArguments(String[] args) {
        return (String[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Function1 & Serializable)x0$1 -> {
            Iterator xs;
            Option<Iterator<String>> option;
            String string = x0$1;
            Object object = string != null && !(option = Cli$FileArgument$.MODULE$.unapply(string)).isEmpty() ? (xs = (Iterator)option.get()) : package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{string}));
            return object;
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public ExitCode run(CliOptions options) {
        ExitCode exitCode;
        Either<String, ScalafmtRunner> either = this.findRunner(options);
        if (either instanceof Left) {
            Left left = (Left)either;
            String message = (String)left.value();
            options.common().err().println(message);
            exitCode = ExitCode$.MODULE$.UnsupportedVersion();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            ScalafmtRunner runner = (ScalafmtRunner)right.value();
            exitCode = this.runWithRunner(options, runner);
        } else {
            throw new MatchError(either);
        }
        return exitCode;
    }

    private boolean isNativeImage() {
        return isNativeImage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<String, ScalafmtRunner> findRunner(CliOptions options) {
        Option<String> option = options.getVersionIfDifferent();
        if (option instanceof Some) {
            Some some = (Some)option;
            String v = (String)some.value();
            if (this.isNativeImage()) {
                return package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(501).append("error: invalid Scalafmt version.\n            |\n            |This Scalafmt installation has version '").append(Versions$.MODULE$.version()).append("' and the version configured in '").append(options.configPath()).append("' is '").append(v).append("'.\n            |To fix this problem, add the following line to .scalafmt.conf:\n            |```\n            |version = '").append(Versions$.MODULE$.version()).append("'\n            |```\n            |\n            |NOTE: this error happens only when running a native Scalafmt binary.\n            |Scalafmt automatically installs and invokes the correct version of Scalafmt when running on the JVM.\n            |").toString())));
            }
        }
        if (!None$.MODULE$.equals(option)) return package$.MODULE$.Right().apply((Object)ScalafmtDynamicRunner$.MODULE$);
        return package$.MODULE$.Right().apply((Object)ScalafmtCoreRunner$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ExitCode runWithRunner(CliOptions options, ScalafmtRunner runner) {
        ExitCode exitCode;
        WriteMode writeMode = options.writeMode();
        WriteMode$Test$ writeMode$Test$ = WriteMode$Test$.MODULE$;
        String termDisplayMessage = !(writeMode != null ? !writeMode.equals(writeMode$Test$) : writeMode$Test$ != null) ? "Looking for unformatted files..." : "Reformatting...";
        options.common().debug().println(new StringBuilder(19).append("Working directory: ").append(options.common().workingDirectory().jfile().getPath()).toString());
        ExitCode exit = runner.run(options, termDisplayMessage);
        WriteMode writeMode2 = options.writeMode();
        WriteMode$Test$ writeMode$Test$2 = WriteMode$Test$.MODULE$;
        if (!(writeMode2 != null ? !writeMode2.equals(writeMode$Test$2) : writeMode$Test$2 != null)) {
            if (exit.isOk()) {
                options.common().out().println("All files are formatted with scalafmt :)");
            } else if (exit.is(ExitCode$.MODULE$.TestError())) {
                options.common().out().println("error: --test failed");
                options.onTestFailure().foreach((Function1 & Serializable)x$1 -> {
                    Cli$.$anonfun$runWithRunner$1(options, x$1);
                    return BoxedUnit.UNIT;
                });
            } else {
                options.common().out().println(new StringBuilder(7).append("error: ").append(exit).toString());
            }
        }
        WriteMode writeMode3 = options.writeMode();
        WriteMode$Test$ writeMode$Test$3 = WriteMode$Test$.MODULE$;
        if (!(writeMode3 != null ? !writeMode3.equals(writeMode$Test$3) : writeMode$Test$3 != null)) {
            if (!options.fatalWarnings() && !exit.is(ExitCode$.MODULE$.TestError())) {
                exitCode = ExitCode$.MODULE$.Ok();
                return exitCode;
            }
        }
        exitCode = exit;
        return exitCode;
    }

    public static final /* synthetic */ void $anonfun$runWithRunner$1(CliOptions options$1, String x$1) {
        options$1.common().out().println(x$1);
    }

    private Cli$() {
    }
}

