/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.util.concurrent.TimeUnit;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.Stats$;
import scala.concurrent.stm.ccstm.WakeupManager;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!B\u0001\u0003\u0001\tQ!\u0001\u0003*fiJL8+\u001a;\u000b\u0005\r!\u0011!B2dgRl'BA\u0003\u0007\u0003\r\u0019H/\u001c\u0006\u0003\u000f!\t!bY8oGV\u0014(/\u001a8u\u0015\u0005I\u0011!B:dC2\f7C\u0001\u0001\f!\taQ\"D\u0001\t\u0013\tq\u0001B\u0001\u0004B]f\u0014VM\u001a\u0005\t!\u0001\u0011)\u0019!C\u0001%\u0005!1/\u001b>f\u0007\u0001)\u0012a\u0005\t\u0003\u0019QI!!\u0006\u0005\u0003\u0007%sG\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0014\u0003\u0015\u0019\u0018N_3!\u0011!I\u0002A!A!\u0002\u0013Q\u0012a\u00025b]\u0012dWm\u001d\t\u0004\u0019mi\u0012B\u0001\u000f\t\u0005\u0015\t%O]1za\tqB\u0005E\u0002 A\tj\u0011AA\u0005\u0003C\t\u0011a\u0001S1oI2,\u0007CA\u0012%\u0019\u0001!\u0011\"\n\r\u0002\u0002\u0003\u0005)\u0011\u0001\u0014\u0003\u0007}#\u0013'\u0005\u0002(UA\u0011A\u0002K\u0005\u0003S!\u0011qAT8uQ&tw\r\u0005\u0002\rW%\u0011A\u0006\u0003\u0002\u0004\u0003:L\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u0011Y,'o]5p]N\u00042\u0001D\u000e1!\t\tDG\u0004\u0002 e%\u00111GA\u0001\u0006\u0007\u000e\u001bF+T\u0005\u0003kY\u0012qAV3sg&|gN\u0003\u00024\u0005!)\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"BAO\u001e=\u0005B\u0011q\u0004\u0001\u0005\u0006!]\u0002\ra\u0005\u0005\u00063]\u0002\r!\u0010\t\u0004\u0019mq\u0004GA B!\ry\u0002\u0005\u0011\t\u0003G\u0005#\u0011\"\n\u001f\u0002\u0002\u0003\u0005)\u0011\u0001\u0014\t\u000b9:\u0004\u0019A\u0018\t\u000b\u0011\u0003A\u0011A#\u0002\u0015\u0005<\u0018-\u001b;SKR\u0014\u0018\u0010\u0006\u0002G\u0013B\u0011AbR\u0005\u0003\u0011\"\u0011A\u0001T8oO\")!j\u0011a\u0001\r\u0006aA/[7f_V$h*\u00198pg\"\u001a1\tT.\u0011\u00071iu*\u0003\u0002O\u0011\t1A\u000f\u001b:poN\u0004\"\u0001\u0015-\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+\u0012\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002X\u0011\u00059\u0001/Y2lC\u001e,\u0017BA-[\u0005QIe\u000e^3seV\u0004H/\u001a3Fq\u000e,\u0007\u000f^5p]*\u0011q\u000bC\u0012\u0002\u001f\")Q\f\u0001C\u0005=\u0006a\u0011\r\u001e;f[B$\u0018i^1jiR\u0011qL\u0019\t\u0003\u0019\u0001L!!\u0019\u0005\u0003\u000f\t{w\u000e\\3b]\")1\r\u0018a\u0001\r\u0006aa.\u00198p\t\u0016\fG\r\\5oK\"\u001aA\fT.\t\u000b\u0019\u0004A\u0011B4\u0002)\tdwnY6j]\u001e\fE\u000f^3naR\fu/Y5u)\u0011y\u0006.\u001b:\t\u000b\r,\u0007\u0019\u0001$\t\u000f),\u0007\u0013!a\u0001W\u0006)QM^3oiB\u0011An\u001c\b\u0003?5L!A\u001c\u0002\u0002\u001b]\u000b7.Z;q\u001b\u0006t\u0017mZ3s\u0013\t\u0001\u0018OA\u0003Fm\u0016tGO\u0003\u0002o\u0005!91/\u001aI\u0001\u0002\u0004\u0019\u0012!A5)\u0005\u0015,\bC\u0001<z\u001b\u00059(B\u0001=\t\u0003)\tgN\\8uCRLwN\\\u0005\u0003u^\u0014q\u0001^1jYJ,7\rK\u0002f\u0019nCQ! \u0001\u0005\ny\f\u0001#\u00193e!\u0016tG-\u001b8h/\u0006\\W-\u001e9\u0015\t}{\u0018Q\u0002\u0005\b\u0003\u0003a\b\u0019AA\u0002\u0003\u0019A\u0017M\u001c3mKB\"\u0011QAA\u0005!\u0011y\u0002%a\u0002\u0011\u0007\r\nI\u0001\u0002\u0006\u0002\f}\f\t\u0011!A\u0003\u0002\u0019\u00121a\u0018\u00133\u0011\u0019\ty\u0001 a\u0001a\u0005\u0019a/\u001a:)\u0005q,\bbBA\u000b\u0001\u0011%\u0011qC\u0001\bG\"\fgnZ3e+\u0005y\u0006\"CA\u000e\u0001E\u0005I\u0011BA\u000f\u0003y\u0011Gn\\2lS:<\u0017\t\u001e;f[B$\u0018i^1ji\u0012\"WMZ1vYR$#'\u0006\u0002\u0002 )\u001a1.!\t,\u0005\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%r/A\u0005v]\u000eDWmY6fI&!\u0011QFA\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003c\u0001\u0011\u0013!C\u0005\u0003g\taD\u00197pG.LgnZ!ui\u0016l\u0007\u000f^!xC&$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U\"fA\n\u0002\"\u0001")
public class RetrySet {
    private final int size;
    private final Handle<?>[] handles;
    private final long[] versions;

    public int size() {
        return this.size;
    }

    public long awaitRetry(long timeoutNanos) throws InterruptedException {
        if (this.size() == 0 && timeoutNanos == Long.MAX_VALUE) {
            throw new IllegalStateException("explicit retries cannot succeed because cumulative read set is empty");
        }
        long begin = System.nanoTime();
        long d = begin + timeoutNanos;
        long deadline = d < 0L ? Long.MAX_VALUE : d;
        this.attemptAwait(deadline);
        long actualElapsed = System.nanoTime() - begin;
        if (Stats$.MODULE$.top() != null) {
            Stats$.MODULE$.top().retrySet().$plus$eq(this.size());
            long millis = TimeUnit.NANOSECONDS.toMillis(actualElapsed);
            Stats$.MODULE$.top().retryWaitElapsed().$plus$eq((int)millis);
        }
        return package$.MODULE$.min(actualElapsed, deadline - begin);
    }

    private boolean attemptAwait(long nanoDeadline) throws InterruptedException {
        int spins = 0;
        while (this.size() > 0 && spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount()) {
            if (this.changed()) {
                return true;
            }
            if ((spins += this.size()) <= CCSTM$.MODULE$.SpinCount()) continue;
            Thread.yield();
            if (nanoDeadline == Long.MAX_VALUE || System.nanoTime() <= nanoDeadline) continue;
            return false;
        }
        return this.blockingAttemptAwait(nanoDeadline, this.blockingAttemptAwait$default$2(), this.blockingAttemptAwait$default$3());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean blockingAttemptAwait(long nanoDeadline, WakeupManager.Event event, int i) throws InterruptedException {
        while (true) {
            if (i < 0) {
                if (!event.tryAwaitUntil(nanoDeadline)) return false;
                if (this.changed()) {
                    return true;
                }
                i = this.blockingAttemptAwait$default$3();
                event = this.blockingAttemptAwait$default$2();
                continue;
            }
            Handle<?> h = this.handles[i];
            if (event.addSource(h)) {
                if (!this.addPendingWakeup(h, this.versions[i])) return true;
                --i;
                continue;
            }
            if (this.changed()) {
                return true;
            }
            i = this.blockingAttemptAwait$default$3();
            event = this.blockingAttemptAwait$default$2();
        }
    }

    private WakeupManager.Event blockingAttemptAwait$default$2() {
        return CCSTM$.MODULE$.wakeupManager().subscribe();
    }

    private int blockingAttemptAwait$default$3() {
        return this.size() - 1;
    }

    private boolean addPendingWakeup(Handle<?> handle, long ver) {
        while (true) {
            boolean bl;
            long m;
            if (CCSTM$.MODULE$.changing(m = handle.meta()) || CCSTM$.MODULE$.version(m) != ver) {
                bl = false;
            } else {
                if (!CCSTM$.MODULE$.pendingWakeups(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m))) continue;
                bl = true;
            }
            return bl;
        }
    }

    private boolean changed() {
        for (int i = this.size() - 1; i >= 0; --i) {
            long m = this.handles[i].meta();
            if (!CCSTM$.MODULE$.changing(m) && CCSTM$.MODULE$.version(m) == this.versions[i]) continue;
            return true;
        }
        return false;
    }

    public RetrySet(int size, Handle<?>[] handles, long[] versions) {
        this.size = size;
        this.handles = handles;
        this.versions = versions;
    }
}

