/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.richfaces.component.AbstractSelectManyComponent;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.component.util.SelectUtils;
import org.richfaces.renderkit.ClientSelectItem;
import org.richfaces.renderkit.InputRendererBase;
import org.richfaces.renderkit.SelectManyHelper;
import org.richfaces.renderkit.util.HtmlDimensions;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="jquery.position.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-utils.js"), @ResourceDependency(name="richfaces-selection.js"), @ResourceDependency(library="org.richfaces", name="inputBase.js"), @ResourceDependency(library="org.richfaces", name="popup.js"), @ResourceDependency(library="org.richfaces", name="list.js"), @ResourceDependency(library="org.richfaces", name="listMulti.js"), @ResourceDependency(library="org.richfaces", name="popupList.js"), @ResourceDependency(library="org.richfaces", name="pickList.js"), @ResourceDependency(library="org.richfaces", name="pickList.ecss")})
public class SelectManyRendererBase
extends InputRendererBase {
    private static final String HIDDEN_SUFFIX = "Hidden";

    public List<ClientSelectItem> getClientSelectItems(FacesContext facesContext, UIComponent component) {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        return SelectManyHelper.getClientSelectItems(facesContext, select, SelectUtils.getSelectItems(facesContext, component));
    }

    public String csvEncodeSelectedItems(List<ClientSelectItem> clientSelectItems) {
        if (clientSelectItems == null || clientSelectItems.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ClientSelectItem item : clientSelectItems) {
            if (!item.isSelected()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(item.getConvertedValue());
        }
        return sb.toString();
    }

    @Override
    protected void doDecode(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof AbstractSelectManyComponent)) {
            throw new IllegalArgumentException(String.format("Component %s is not an AbstractSelectManyComponent", component.getClientId(facesContext)));
        }
        AbstractSelectManyComponent picklist = (AbstractSelectManyComponent)component;
        String hiddenClientId = picklist.getClientId(facesContext);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (picklist.isDisabled()) {
            return;
        }
        String value = (String)paramMap.get(hiddenClientId);
        if (value != null) {
            if (value.trim().equals("")) {
                picklist.setSubmittedValue(new String[0]);
            } else {
                String[] reqValues = value.split(",");
                picklist.setSubmittedValue(reqValues);
            }
        } else {
            picklist.setSubmittedValue(new String[0]);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object val) throws ConverterException {
        return SelectManyHelper.getConvertedValue(facesContext, component, val);
    }

    public boolean hasColumnChildren(FacesContext facesContext, UIComponent component) {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        return select.columns().hasNext();
    }

    public boolean isHeaderExists(FacesContext facesContext, UIComponent component) {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        Iterator<UIColumn> columnIterator = select.columns();
        while (columnIterator.hasNext()) {
            UIColumn column = columnIterator.next();
            if (column.getFacet("header") == null) continue;
            return true;
        }
        return false;
    }

    protected String getMinListHeight(AbstractSelectManyComponent select) {
        String height = HtmlDimensions.formatSize((String)select.getMinListHeight());
        if (height == null || height.length() == 0) {
            height = "20px";
        }
        return height;
    }

    protected String getMaxListHeight(AbstractSelectManyComponent select) {
        String height = HtmlDimensions.formatSize((String)select.getMaxListHeight());
        if (height == null || height.length() == 0) {
            height = "100px";
        }
        return height;
    }

    protected String getListHeight(AbstractSelectManyComponent select) {
        String height = HtmlDimensions.formatSize((String)select.getListHeight());
        if (height == null || height.length() == 0) {
            height = "auto";
        }
        return height;
    }

    protected String getListWidth(AbstractSelectManyComponent select) {
        String width = HtmlDimensions.formatSize((String)select.getListWidth());
        if (width == null || width.length() == 0) {
            width = "200px";
        }
        return width;
    }

    public String encodeHeightAndWidth(UIComponent component) {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        String height = this.getListHeight(select);
        if (!"auto".equals(height)) {
            height = height != null && height.trim().length() != 0 ? "height: " + height : "";
        } else {
            String minHeight = this.getMinListHeight(select);
            minHeight = minHeight != null && minHeight.trim().length() != 0 ? "min-height: " + minHeight : "";
            String maxHeight = this.getMaxListHeight(select);
            maxHeight = maxHeight != null && maxHeight.trim().length() != 0 ? "max-height: " + maxHeight : "";
            height = this.concatStyles(minHeight, maxHeight);
        }
        String width = this.getListWidth(select);
        width = width != null && width.trim().length() != 0 ? "width: " + width : "";
        return this.concatStyles(height, width);
    }

    public String getButtonClass(UIComponent component, String cssPrefix, String buttonClass) {
        AbstractSelectManyComponent select = (AbstractSelectManyComponent)component;
        if (!select.isDisabled()) {
            return HtmlUtil.concatClasses(buttonClass, cssPrefix + "-btn");
        }
        return HtmlUtil.concatClasses(buttonClass, cssPrefix + "-btn", cssPrefix + "-btn-dis");
    }
}

