/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.orderingList;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.bootstrap.ui.orderingList.AbstractOrderingList;
import org.richfaces.bootstrap.ui.orderingList.OrderingListRendererBase;
import org.richfaces.renderkit.ClientSelectItem;
import org.richfaces.renderkit.ForEachLoop;
import org.richfaces.renderkit.RenderKitUtils;

public class OrderingListRenderer
extends OrderingListRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES7 = RenderKitUtils.attributes().generic("onclick", "onclick", new String[]{"click"}).generic("ondblclick", "ondblclick", new String[]{"dblclick"}).generic("onkeydown", "onkeydown", new String[]{"keydown"}).generic("onkeypress", "onkeypress", new String[]{"keypress"}).generic("onkeyup", "onkeyup", new String[]{"keyup"}).generic("onmousedown", "onmousedown", new String[]{"mousedown"}).generic("onmousemove", "onmousemove", new String[]{"mousemove"}).generic("onmouseout", "onmouseout", new String[]{"mouseout"}).generic("onmouseover", "onmouseover", new String[]{"mouseover"}).generic("onmouseup", "onmouseup", new String[]{"mouseup"}).generic("style", "style", new String[0]);
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH1 = RenderKitUtils.attributes().generic("onchange", "onchange", new String[]{"change"});

    private static boolean convertToBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return Boolean.valueOf(object.toString());
    }

    public void renderColumnHeaders(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterator columns) throws IOException {
        AbstractOrderingList component = (AbstractOrderingList)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("thead", (UIComponent)component);
        responseWriter.startElement("tr", (UIComponent)component);
        while (columns.hasNext()) {
            UIComponent header;
            Object columnObject = columns.next();
            UIColumn column = (UIColumn)columnObject;
            responseWriter.startElement("th", (UIComponent)component);
            if (OrderingListRenderer.convertToBoolean(RenderKitUtils.hasFacet((UIComponent)column, (String)"header")) && (header = column.getHeader()).isRendered()) {
                header.encodeBegin(facesContext);
                this.renderChildren(facesContext, header);
                header.encodeEnd(facesContext);
            }
            responseWriter.endElement("th");
        }
        responseWriter.endElement("tr");
        responseWriter.endElement("thead");
    }

    public void renderColumns(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterator columns, List clientSelectItems) throws IOException {
        AbstractOrderingList component = (AbstractOrderingList)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("tbody", (UIComponent)component);
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object oldVar = requestMap.get(component.getVar());
        String[] columnClasses = component.getColumnClasses() != null ? component.getColumnClasses().split(",") : null;
        for (Object itemObject : clientSelectItems) {
            ClientSelectItem item = (ClientSelectItem)itemObject;
            columns = component.columns();
            requestMap.put(component.getVar(), item.getSelectItem().getValue());
            responseWriter.startElement("tr", (UIComponent)component);
            String value = item.getConvertedValue();
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("data-key", (Object)value, null);
            }
            ForEachLoop forEach2 = ForEachLoop.getInstance((Iterator)columns);
            for (Object columnObject : forEach2) {
                ForEachLoop.Status varStatus = forEach2.getStatus();
                UIColumn column = (UIColumn)columnObject;
                responseWriter.startElement("td", (UIComponent)component);
                String value2 = this.getColumnClass(column, columnClasses, varStatus.getIndex());
                if (null != value2 && RenderKitUtils.shouldRenderAttribute((Object)value2)) {
                    responseWriter.writeAttribute("class", (Object)value2, null);
                }
                column.encodeBegin(facesContext);
                this.renderChildren(facesContext, (UIComponent)column);
                column.encodeEnd(facesContext);
                responseWriter.endElement("td");
            }
            responseWriter.endElement("tr");
        }
        requestMap.put(component.getVar(), oldVar);
        oldVar = null;
        responseWriter.endElement("tbody");
    }

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String text;
        AbstractOrderingList component = (AbstractOrderingList)uiComponent;
        String clientId = component.getClientId(facesContext);
        List clientSelectItems = this.getClientSelectItems(facesContext, (UIComponent)component);
        responseWriter.startElement("div", (UIComponent)component);
        String value = component.getStyleClass();
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        RenderKitUtils.renderPassThroughAttributes((FacesContext)facesContext, (UIComponent)component, (Collection)PASS_THROUGH_ATTRIBUTES7);
        responseWriter.startElement("input", (UIComponent)component);
        value = OrderingListRenderer.convertToString(clientId) + "ListInput";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("name", (Object)value, null);
        }
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.endElement("input");
        if (!this.hasColumnChildren(facesContext, (UIComponent)component)) {
            responseWriter.startElement("ol", (UIComponent)component);
            value = OrderingListRenderer.convertToString(clientId) + "List";
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("id", (Object)value, null);
            }
            for (Object itemObject : clientSelectItems) {
                ClientSelectItem item = (ClientSelectItem)itemObject;
                responseWriter.startElement("li", (UIComponent)component);
                String value2 = item.getConvertedValue();
                if (null != value2 && value2.length() > 0) {
                    responseWriter.writeAttribute("data-key", (Object)value2, null);
                }
                if ((text = item.getLabel()) != null) {
                    responseWriter.writeText((Object)text, null);
                }
                responseWriter.endElement("li");
            }
            responseWriter.endElement("ol");
        } else {
            Iterator columns = component.columns();
            responseWriter.startElement("table", (UIComponent)component);
            String value3 = OrderingListRenderer.convertToString(clientId) + "List";
            if (null != value3 && value3.length() > 0) {
                responseWriter.writeAttribute("id", (Object)value3, null);
            }
            if (columns != null && columns.hasNext()) {
                if (this.isHeaderExists(facesContext, (UIComponent)component)) {
                    this.renderColumnHeaders(responseWriter, facesContext, (UIComponent)component, columns);
                }
                this.renderColumns(responseWriter, facesContext, (UIComponent)component, columns, clientSelectItems);
            }
            responseWriter.endElement("table");
        }
        responseWriter.endElement("div");
        responseWriter.startElement("script", (UIComponent)component);
        responseWriter.writeAttribute("type", (Object)"text/javascript", null);
        LinkedHashMap listDimensions = new LinkedHashMap();
        RenderKitUtils.addToScriptHash(listDimensions, (String)"width", (Object)component.getListWidth(), null, null);
        RenderKitUtils.addToScriptHash(listDimensions, (String)"height", (Object)component.getListHeight(), null, null);
        RenderKitUtils.addToScriptHash(listDimensions, (String)"min-height", (Object)component.getMinListHeight(), null, null);
        RenderKitUtils.addToScriptHash(listDimensions, (String)"max-height", (Object)component.getMaxListHeight(), null, null);
        LinkedHashMap widgetOptions = new LinkedHashMap();
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"header", (Object)component.getCaption(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"headerClass", (Object)component.getCaptionStyleClass(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"disabled", (Object)component.isDisabled(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"disabledClass", (Object)component.getDisabledClass(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"selecteeClass", (Object)component.getItemStyleClass(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"selectedClass", (Object)component.getSelectedItemStyleClass(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"dimensions", listDimensions, null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"dragSelect", (Object)component.isDragSelect(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"showButtons", (Object)(component.isHideButtons() ? "false" : ""), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"mouseOrderable", (Object)(component.isDisableMouse() ? "false" : ""), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"contained", (Object)(!component.isContained() ? "false" : ""), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"buttonsStyleClass", (Object)component.getButtonsStyleClass(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"placeholderStyleClass", (Object)component.getPlaceholderStyleClass(), null, null);
        RenderKitUtils.addToScriptHash(widgetOptions, (String)"helperStyleClass", (Object)component.getHelperStyleClass(), null, null);
        LinkedHashMap bridgeOptions = new LinkedHashMap();
        RenderKitUtils.addToScriptHash(bridgeOptions, (String)"componentId", (Object)clientId, null, null);
        RenderKitUtils.addToScriptHash(bridgeOptions, (FacesContext)facesContext, (UIComponent)component, (RenderKitUtils.Attributes)ATTRIBUTES_FOR_SCRIPT_HASH1, (RenderKitUtils.ScriptHashVariableWrapper)RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        text = "jQuery(function() {\n                var $list = $(document.getElementById('" + OrderingListRenderer.convertToString(clientId) + "List'));\n                $list.orderingList(" + OrderingListRenderer.convertToString(RenderKitUtils.toScriptArgs((Object[])new Object[]{widgetOptions})) + ");\n                $list.orderingListBridge(" + OrderingListRenderer.convertToString(RenderKitUtils.toScriptArgs((Object[])new Object[]{bridgeOptions})) + ");\n            });";
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("script");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

