/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.navbar;

import java.io.IOException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.bootstrap.semantic.AbstractMenuFacet;
import org.richfaces.bootstrap.semantic.AbstractPositionFacet;
import org.richfaces.bootstrap.ui.navbar.AbstractNavbar;
import org.richfaces.renderkit.RendererBase;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(library="org.richfaces", name="bootstrap-css.reslib"), @ResourceDependency(library="org.richfaces", name="bootstrap-js.reslib")})
public abstract class NavbarRendererBase
extends RendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.bootstrap.NavbarRenderer";

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractNavbar navbar = (AbstractNavbar)component;
        boolean hasPositionFacet = this.hasPositionFacet((UIComponent)navbar);
        if (navbar.isCollapsible()) {
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)(component.getId() + "_collapse"), null);
            writer.writeAttribute("class", (Object)"nav-collapse", null);
        }
        if (!hasPositionFacet) {
            writer.startElement("ul", component);
            writer.writeAttribute("class", (Object)"nav", null);
        }
        for (UIComponent child : navbar.getChildren()) {
            if (child instanceof AbstractMenuFacet || child instanceof AbstractPositionFacet) {
                child.encodeAll(context);
                continue;
            }
            writer.startElement("li", (UIComponent)navbar);
            child.encodeAll(context);
            writer.endElement("li");
        }
        if (!hasPositionFacet) {
            writer.endElement("ul");
        }
        if (navbar.isCollapsible()) {
            writer.endElement("div");
        }
    }

    private boolean hasPositionFacet(UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof AbstractPositionFacet)) continue;
            return true;
        }
        return false;
    }
}

