/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.input;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.bootstrap.ui.input.AbstractInput;
import org.richfaces.bootstrap.ui.input.InputRendererBase;
import org.richfaces.renderkit.RenderKitUtils;

public class InputRenderer
extends InputRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES4 = RenderKitUtils.attributes().generic("placeholder", "placeholder", new String[0]).generic("style", "style", new String[0]).generic("type", "type", new String[0]).generic("value", "value", new String[0]);

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String value;
        String scaleClass;
        AbstractInput component = (AbstractInput)uiComponent;
        String clientId = component.getClientId(facesContext);
        this.encodeBeginWrapper(facesContext, (UIComponent)component);
        if (component.hasFacet("prepend")) {
            for (UIComponent child : component.getFacetChildren("prepend")) {
                if (component.isChildBtn(child)) {
                    child.encodeAll(facesContext);
                    continue;
                }
                responseWriter.startElement("span", (UIComponent)component);
                responseWriter.writeAttribute("class", (Object)"add-on", null);
                child.encodeAll(facesContext);
                responseWriter.endElement("span");
            }
        }
        String string = scaleClass = InputRenderer.isEmpty(component.getScale()) ? "" : "input-".concat(component.getScale());
        if (component.isReadonly()) {
            Object text;
            responseWriter.startElement("span", (UIComponent)component);
            value = "uneditable-input " + InputRenderer.convertToString(scaleClass);
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            if ((text = component.getValue()) != null) {
                responseWriter.writeText(text, null);
            }
            responseWriter.endElement("span");
        } else {
            responseWriter.startElement("input", (UIComponent)component);
            value = InputRenderer.convertToString(InputRenderer.isEmpty(component.getSeverity()) ? "" : "input-".concat(component.getSeverity())) + " " + InputRenderer.convertToString(scaleClass) + " " + InputRenderer.convertToString(component.isDisabled() ? "disabled" : "") + " " + InputRenderer.convertToString(component.getStyleClass());
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            if (null != (value = clientId) && value.length() > 0) {
                responseWriter.writeAttribute("id", (Object)value, null);
            }
            if (null != (value = clientId) && value.length() > 0) {
                responseWriter.writeAttribute("name", (Object)value, null);
            }
            RenderKitUtils.renderPassThroughAttributes((FacesContext)facesContext, (UIComponent)component, (Collection)PASS_THROUGH_ATTRIBUTES4);
            this.addDisabledAttribute(facesContext, (UIComponent)component);
            responseWriter.endElement("input");
        }
        if (component.hasFacet("append")) {
            for (UIComponent child : component.getFacetChildren("append")) {
                if (component.isChildBtn(child)) {
                    child.encodeAll(facesContext);
                    continue;
                }
                responseWriter.startElement("span", (UIComponent)component);
                responseWriter.writeAttribute("class", (Object)"add-on", null);
                child.encodeAll(facesContext);
                responseWriter.endElement("span");
            }
        }
        this.encodeEndWrapper(facesContext, (UIComponent)component);
    }
}

