/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.ui.alert;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.bootstrap.ui.alert.AbstractAlert;
import org.richfaces.bootstrap.ui.alert.AlertRendererBase;
import org.richfaces.renderkit.RenderKitUtils;

public class AlertRenderer
extends AlertRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES8 = RenderKitUtils.attributes().generic("onclick", "onclick", new String[0]).generic("ondblclick", "ondblclick", new String[0]).generic("onkeydown", "onkeydown", new String[0]).generic("onkeypress", "onkeypress", new String[0]).generic("onkeyup", "onkeyup", new String[0]).generic("onmousedown", "onmousedown", new String[0]).generic("onmousemove", "onmousemove", new String[0]).generic("onmouseout", "onmouseout", new String[0]).generic("onmouseover", "onmouseover", new String[0]).generic("onmouseup", "onmouseup", new String[0]).generic("style", "style", new String[0]).generic("title", "title", new String[0]);

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    private static boolean isEqual(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    public void renderIcon(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, String icon, String severity) throws IOException {
        AbstractAlert component = (AbstractAlert)uiComponent;
        String clientId = component.getClientId(facesContext);
        if (AlertRenderer.isEqual(icon, "default")) {
            if (AlertRenderer.isEmpty(severity)) {
                responseWriter.startElement("i", (UIComponent)component);
                responseWriter.writeAttribute("class", (Object)"alert-icon icon-warning-sign", null);
                responseWriter.endElement("i");
            } else if (AlertRenderer.isEqual(severity, "success")) {
                responseWriter.startElement("i", (UIComponent)component);
                responseWriter.writeAttribute("class", (Object)"alert-icon icon-ok-sign", null);
                responseWriter.endElement("i");
            } else if (AlertRenderer.isEqual(severity, "info")) {
                responseWriter.startElement("i", (UIComponent)component);
                responseWriter.writeAttribute("class", (Object)"alert-icon icon-info-sign", null);
                responseWriter.endElement("i");
            } else if (AlertRenderer.isEqual(severity, "error") || AlertRenderer.isEqual(severity, "danger")) {
                responseWriter.startElement("i", (UIComponent)component);
                responseWriter.writeAttribute("class", (Object)"alert-icon icon-remove-sign", null);
                responseWriter.endElement("i");
            }
        }
        if (!AlertRenderer.isEqual(icon, "default")) {
            responseWriter.startElement("i", (UIComponent)component);
            String value = "alert-icon icon-" + AlertRenderer.convertToString(icon);
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            responseWriter.endElement("i");
        }
        responseWriter.writeText((Object)" ", null);
    }

    public void doEncodeBegin(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractAlert component = (AbstractAlert)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("div", (UIComponent)component);
        String value = "alert " + AlertRenderer.convertToString(AlertRenderer.isEqual(component.getLayout(), "block") ? "alert-block" : "") + " " + AlertRenderer.convertToString(AlertRenderer.isEmpty(component.getSeverity()) ? "" : "alert-".concat(component.getSeverity())) + " " + AlertRenderer.convertToString(component.getStyleClass());
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        RenderKitUtils.renderPassThroughAttributes((FacesContext)facesContext, (UIComponent)component, (Collection)PASS_THROUGH_ATTRIBUTES8);
        if (component.isClosable()) {
            responseWriter.startElement("a", (UIComponent)component);
            responseWriter.writeAttribute("class", (Object)"close", null);
            responseWriter.writeAttribute("data-dismiss", (Object)"alert", null);
            responseWriter.writeText((Object)"\u00d7", null);
            responseWriter.endElement("a");
        }
        if (component.getHeader() != null && !component.getHeader().equals("")) {
            String text;
            responseWriter.startElement("h4", (UIComponent)component);
            value = "alert-heading " + AlertRenderer.convertToString(component.getHeaderStyleClass());
            if (null != value && value.length() > 0) {
                responseWriter.writeAttribute("class", (Object)value, null);
            }
            if (!AlertRenderer.isEmpty(component.getIcon())) {
                this.renderIcon(responseWriter, facesContext, (UIComponent)component, component.getIcon(), component.getSeverity());
            }
            if ((text = component.getHeader()) != null) {
                responseWriter.writeText((Object)text, null);
            }
            responseWriter.endElement("h4");
        }
        if (component.getHeader() == null || component.getHeader().equals("") && !AlertRenderer.isEmpty(component.getIcon())) {
            this.renderIcon(responseWriter, facesContext, (UIComponent)component, component.getIcon(), component.getSeverity());
        }
    }

    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractAlert component = (AbstractAlert)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.endElement("div");
    }
}

